/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.searchablesnapshots;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class SearchableSnapshotShardStats
implements Writeable,
ToXContentObject {
    private final List<CacheIndexInputStats> inputStats;
    private final ShardRouting shardRouting;
    private final SnapshotId snapshotId;
    private final IndexId indexId;

    public SearchableSnapshotShardStats(ShardRouting shardRouting, SnapshotId snapshotId, IndexId indexId, List<CacheIndexInputStats> stats) {
        this.shardRouting = Objects.requireNonNull(shardRouting);
        this.snapshotId = Objects.requireNonNull(snapshotId);
        this.indexId = Objects.requireNonNull(indexId);
        this.inputStats = Collections.unmodifiableList(Objects.requireNonNull(stats));
    }

    public SearchableSnapshotShardStats(StreamInput in) throws IOException {
        this.shardRouting = new ShardRouting(in);
        this.snapshotId = new SnapshotId(in);
        this.indexId = new IndexId(in);
        this.inputStats = in.readList(CacheIndexInputStats::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.shardRouting.writeTo(out);
        this.snapshotId.writeTo(out);
        this.indexId.writeTo(out);
        out.writeList(this.inputStats);
    }

    public ShardRouting getShardRouting() {
        return this.shardRouting;
    }

    public SnapshotId getSnapshotId() {
        return this.snapshotId;
    }

    public IndexId getIndexId() {
        return this.indexId;
    }

    public List<CacheIndexInputStats> getStats() {
        return this.inputStats;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("snapshot_uuid", this.getSnapshotId().getUUID());
        builder.field("index_uuid", this.getIndexId().getId());
        builder.startObject("shard");
        builder.field("id", (ToXContent)this.shardRouting.shardId());
        builder.field("state", (Enum)this.shardRouting.state());
        builder.field("primary", this.shardRouting.primary());
        builder.field("node", this.shardRouting.currentNodeId());
        if (this.shardRouting.relocatingNodeId() != null) {
            builder.field("relocating_node", this.shardRouting.relocatingNodeId());
        }
        builder.endObject();
        builder.startArray("files");
        List stats = this.inputStats.stream().sorted(Comparator.comparing(CacheIndexInputStats::getFileExt)).collect(Collectors.toList());
        for (CacheIndexInputStats stat : stats) {
            stat.toXContent(builder, params);
        }
        builder.endArray();
        return builder.endObject();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SearchableSnapshotShardStats that = (SearchableSnapshotShardStats)other;
        return Objects.equals(this.shardRouting, that.shardRouting) && Objects.equals(this.snapshotId, that.snapshotId) && Objects.equals(this.indexId, that.indexId) && Objects.equals(this.inputStats, that.inputStats);
    }

    public int hashCode() {
        return Objects.hash(this.shardRouting, this.snapshotId, this.indexId, this.inputStats);
    }

    public static class CacheIndexInputStats
    implements Writeable,
    ToXContentObject {
        private final String fileExt;
        private final long numFiles;
        private final ByteSizeValue totalSize;
        private final ByteSizeValue minSize;
        private final ByteSizeValue maxSize;
        private final long openCount;
        private final long closeCount;
        private final Counter forwardSmallSeeks;
        private final Counter backwardSmallSeeks;
        private final Counter forwardLargeSeeks;
        private final Counter backwardLargeSeeks;
        private final Counter contiguousReads;
        private final Counter nonContiguousReads;
        private final Counter cachedBytesRead;
        private final Counter indexCacheBytesRead;
        private final TimedCounter cachedBytesWritten;
        private final TimedCounter directBytesRead;
        private final TimedCounter optimizedBytesRead;
        private final Counter blobStoreBytesRequested;
        private final Counter luceneBytesRead;
        private final long currentIndexCacheFills;

        public CacheIndexInputStats(String fileExt, long numFiles, ByteSizeValue totalSize, ByteSizeValue minSize, ByteSizeValue maxSize, long openCount, long closeCount, Counter forwardSmallSeeks, Counter backwardSmallSeeks, Counter forwardLargeSeeks, Counter backwardLargeSeeks, Counter contiguousReads, Counter nonContiguousReads, Counter cachedBytesRead, Counter indexCacheBytesRead, TimedCounter cachedBytesWritten, TimedCounter directBytesRead, TimedCounter optimizedBytesRead, Counter blobStoreBytesRequested, Counter luceneBytesRead, long currentIndexCacheFills) {
            this.fileExt = fileExt;
            this.numFiles = numFiles;
            this.totalSize = totalSize;
            this.minSize = minSize;
            this.maxSize = maxSize;
            this.openCount = openCount;
            this.closeCount = closeCount;
            this.forwardSmallSeeks = forwardSmallSeeks;
            this.backwardSmallSeeks = backwardSmallSeeks;
            this.forwardLargeSeeks = forwardLargeSeeks;
            this.backwardLargeSeeks = backwardLargeSeeks;
            this.contiguousReads = contiguousReads;
            this.nonContiguousReads = nonContiguousReads;
            this.cachedBytesRead = cachedBytesRead;
            this.indexCacheBytesRead = indexCacheBytesRead;
            this.cachedBytesWritten = cachedBytesWritten;
            this.directBytesRead = directBytesRead;
            this.optimizedBytesRead = optimizedBytesRead;
            this.blobStoreBytesRequested = blobStoreBytesRequested;
            this.luceneBytesRead = luceneBytesRead;
            this.currentIndexCacheFills = currentIndexCacheFills;
        }

        CacheIndexInputStats(StreamInput in) throws IOException {
            if (in.getTransportVersion().before(TransportVersion.V_7_12_0)) {
                throw new IllegalArgumentException("BWC breaking change for internal API");
            }
            this.fileExt = in.readString();
            this.numFiles = in.readVLong();
            if (in.getTransportVersion().before(TransportVersion.V_7_13_0)) {
                this.totalSize = ByteSizeValue.ofBytes((long)in.readVLong());
                this.minSize = ByteSizeValue.ZERO;
                this.maxSize = ByteSizeValue.ZERO;
            } else {
                this.totalSize = ByteSizeValue.readFrom((StreamInput)in);
                this.minSize = ByteSizeValue.readFrom((StreamInput)in);
                this.maxSize = ByteSizeValue.readFrom((StreamInput)in);
            }
            this.openCount = in.readVLong();
            this.closeCount = in.readVLong();
            this.forwardSmallSeeks = new Counter(in);
            this.backwardSmallSeeks = new Counter(in);
            this.forwardLargeSeeks = new Counter(in);
            this.backwardLargeSeeks = new Counter(in);
            this.contiguousReads = new Counter(in);
            this.nonContiguousReads = new Counter(in);
            this.cachedBytesRead = new Counter(in);
            this.indexCacheBytesRead = new Counter(in);
            this.cachedBytesWritten = new TimedCounter(in);
            this.directBytesRead = new TimedCounter(in);
            this.optimizedBytesRead = new TimedCounter(in);
            this.blobStoreBytesRequested = new Counter(in);
            this.luceneBytesRead = in.getTransportVersion().onOrAfter(TransportVersion.V_7_13_0) ? new Counter(in) : new Counter(0L, 0L, 0L, 0L);
            this.currentIndexCacheFills = in.readVLong();
        }

        public static CacheIndexInputStats combine(CacheIndexInputStats cis1, CacheIndexInputStats cis2) {
            if (!cis1.getFileExt().equals(cis2.getFileExt())) {
                assert (false) : "can only combine same file extensions";
                throw new IllegalArgumentException("can only combine same file extensions but was " + cis1.fileExt + " and " + cis2.fileExt);
            }
            return new CacheIndexInputStats(cis1.fileExt, cis1.numFiles + cis2.numFiles, ByteSizeValue.ofBytes((long)Math.addExact(cis1.totalSize.getBytes(), cis2.totalSize.getBytes())), ByteSizeValue.ofBytes((long)Math.min(cis1.minSize.getBytes(), cis2.minSize.getBytes())), ByteSizeValue.ofBytes((long)Math.max(cis1.maxSize.getBytes(), cis2.maxSize.getBytes())), cis1.openCount + cis2.openCount, cis1.closeCount + cis2.closeCount, cis1.forwardSmallSeeks.add(cis2.forwardSmallSeeks), cis1.backwardSmallSeeks.add(cis2.backwardSmallSeeks), cis1.forwardLargeSeeks.add(cis2.forwardLargeSeeks), cis1.backwardLargeSeeks.add(cis2.backwardLargeSeeks), cis1.contiguousReads.add(cis2.contiguousReads), cis1.nonContiguousReads.add(cis2.nonContiguousReads), cis1.cachedBytesRead.add(cis2.cachedBytesRead), cis1.indexCacheBytesRead.add(cis2.indexCacheBytesRead), cis1.cachedBytesWritten.add(cis2.cachedBytesWritten), cis1.directBytesRead.add(cis2.directBytesRead), cis1.optimizedBytesRead.add(cis2.optimizedBytesRead), cis1.blobStoreBytesRequested.add(cis2.blobStoreBytesRequested), cis1.luceneBytesRead.add(cis2.luceneBytesRead), cis1.currentIndexCacheFills + cis2.currentIndexCacheFills);
        }

        public void writeTo(StreamOutput out) throws IOException {
            if (out.getTransportVersion().before(TransportVersion.V_7_12_0)) {
                throw new IllegalArgumentException("BWC breaking change for internal API");
            }
            out.writeString(this.fileExt);
            out.writeVLong(this.numFiles);
            if (out.getTransportVersion().before(TransportVersion.V_7_13_0)) {
                out.writeVLong(this.totalSize.getBytes());
            } else {
                this.totalSize.writeTo(out);
                this.minSize.writeTo(out);
                this.maxSize.writeTo(out);
            }
            out.writeVLong(this.openCount);
            out.writeVLong(this.closeCount);
            this.forwardSmallSeeks.writeTo(out);
            this.backwardSmallSeeks.writeTo(out);
            this.forwardLargeSeeks.writeTo(out);
            this.backwardLargeSeeks.writeTo(out);
            this.contiguousReads.writeTo(out);
            this.nonContiguousReads.writeTo(out);
            this.cachedBytesRead.writeTo(out);
            this.indexCacheBytesRead.writeTo(out);
            this.cachedBytesWritten.writeTo(out);
            this.directBytesRead.writeTo(out);
            this.optimizedBytesRead.writeTo(out);
            this.blobStoreBytesRequested.writeTo(out);
            if (out.getTransportVersion().onOrAfter(TransportVersion.V_7_13_0)) {
                this.luceneBytesRead.writeTo(out);
            }
            out.writeVLong(this.currentIndexCacheFills);
        }

        public String getFileExt() {
            return this.fileExt;
        }

        public long getNumFiles() {
            return this.numFiles;
        }

        public ByteSizeValue getTotalSize() {
            return this.totalSize;
        }

        public ByteSizeValue getMinSize() {
            return this.minSize;
        }

        public ByteSizeValue getMaxSize() {
            return this.maxSize;
        }

        public ByteSizeValue getAverageSize() {
            double average = (double)this.totalSize.getBytes() / (double)this.numFiles;
            return ByteSizeValue.ofBytes((long)Math.round(average));
        }

        public long getOpenCount() {
            return this.openCount;
        }

        public long getCloseCount() {
            return this.closeCount;
        }

        public Counter getForwardSmallSeeks() {
            return this.forwardSmallSeeks;
        }

        public Counter getBackwardSmallSeeks() {
            return this.backwardSmallSeeks;
        }

        public Counter getForwardLargeSeeks() {
            return this.forwardLargeSeeks;
        }

        public Counter getBackwardLargeSeeks() {
            return this.backwardLargeSeeks;
        }

        public Counter getContiguousReads() {
            return this.contiguousReads;
        }

        public Counter getNonContiguousReads() {
            return this.nonContiguousReads;
        }

        public Counter getCachedBytesRead() {
            return this.cachedBytesRead;
        }

        public Counter getIndexCacheBytesRead() {
            return this.indexCacheBytesRead;
        }

        public TimedCounter getCachedBytesWritten() {
            return this.cachedBytesWritten;
        }

        public TimedCounter getDirectBytesRead() {
            return this.directBytesRead;
        }

        public TimedCounter getOptimizedBytesRead() {
            return this.optimizedBytesRead;
        }

        public Counter getBlobStoreBytesRequested() {
            return this.blobStoreBytesRequested;
        }

        public Counter getLuceneBytesRead() {
            return this.luceneBytesRead;
        }

        public long getCurrentIndexCacheFills() {
            return this.currentIndexCacheFills;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("file_ext", this.getFileExt());
            builder.field("num_files", this.getNumFiles());
            builder.field("open_count", this.getOpenCount());
            builder.field("close_count", this.getCloseCount());
            builder.startObject("size");
            builder.humanReadableField("total_in_bytes", "total", (Object)this.getTotalSize());
            builder.humanReadableField("min_in_bytes", "min", (Object)this.getMinSize());
            builder.humanReadableField("max_in_bytes", "max", (Object)this.getMaxSize());
            builder.humanReadableField("average_in_bytes", "average", (Object)this.getAverageSize());
            builder.endObject();
            builder.field("contiguous_bytes_read", (ToXContent)this.getContiguousReads(), params);
            builder.field("non_contiguous_bytes_read", (ToXContent)this.getNonContiguousReads(), params);
            builder.field("cached_bytes_read", (ToXContent)this.getCachedBytesRead(), params);
            builder.field("index_cache_bytes_read", (ToXContent)this.getIndexCacheBytesRead(), params);
            builder.field("cached_bytes_written", (ToXContent)this.getCachedBytesWritten(), params);
            builder.field("direct_bytes_read", (ToXContent)this.getDirectBytesRead(), params);
            builder.field("optimized_bytes_read", (ToXContent)this.getOptimizedBytesRead(), params);
            builder.startObject("forward_seeks");
            builder.field("small", (ToXContent)this.getForwardSmallSeeks(), params);
            builder.field("large", (ToXContent)this.getForwardLargeSeeks(), params);
            builder.endObject();
            builder.startObject("backward_seeks");
            builder.field("small", (ToXContent)this.getBackwardSmallSeeks(), params);
            builder.field("large", (ToXContent)this.getBackwardLargeSeeks(), params);
            builder.endObject();
            builder.field("blob_store_bytes_requested", (ToXContent)this.getBlobStoreBytesRequested(), params);
            builder.field("lucene_bytes_read", (ToXContent)this.getLuceneBytesRead(), params);
            builder.field("current_index_cache_fills", this.getCurrentIndexCacheFills());
            return builder.endObject();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            CacheIndexInputStats stats = (CacheIndexInputStats)other;
            return this.numFiles == stats.numFiles && this.openCount == stats.openCount && this.closeCount == stats.closeCount && Objects.equals(this.fileExt, stats.fileExt) && Objects.equals(this.totalSize, stats.totalSize) && Objects.equals(this.minSize, stats.minSize) && Objects.equals(this.maxSize, stats.maxSize) && Objects.equals(this.forwardSmallSeeks, stats.forwardSmallSeeks) && Objects.equals(this.backwardSmallSeeks, stats.backwardSmallSeeks) && Objects.equals(this.forwardLargeSeeks, stats.forwardLargeSeeks) && Objects.equals(this.backwardLargeSeeks, stats.backwardLargeSeeks) && Objects.equals(this.contiguousReads, stats.contiguousReads) && Objects.equals(this.nonContiguousReads, stats.nonContiguousReads) && Objects.equals(this.cachedBytesRead, stats.cachedBytesRead) && Objects.equals(this.indexCacheBytesRead, stats.indexCacheBytesRead) && Objects.equals(this.cachedBytesWritten, stats.cachedBytesWritten) && Objects.equals(this.directBytesRead, stats.directBytesRead) && Objects.equals(this.optimizedBytesRead, stats.optimizedBytesRead) && Objects.equals(this.blobStoreBytesRequested, stats.blobStoreBytesRequested) && Objects.equals(this.luceneBytesRead, stats.luceneBytesRead) && this.currentIndexCacheFills == stats.currentIndexCacheFills;
        }

        public int hashCode() {
            return Objects.hash(this.fileExt, this.numFiles, this.totalSize, this.minSize, this.maxSize, this.openCount, this.closeCount, this.forwardSmallSeeks, this.backwardSmallSeeks, this.forwardLargeSeeks, this.backwardLargeSeeks, this.contiguousReads, this.nonContiguousReads, this.cachedBytesRead, this.indexCacheBytesRead, this.cachedBytesWritten, this.directBytesRead, this.optimizedBytesRead, this.blobStoreBytesRequested, this.luceneBytesRead, this.currentIndexCacheFills);
        }
    }

    public static class TimedCounter
    extends Counter {
        private final long totalNanoseconds;

        public TimedCounter(long count, long total, long min, long max, long totalNanoseconds) {
            super(count, total, min, max);
            this.totalNanoseconds = totalNanoseconds;
        }

        TimedCounter(StreamInput in) throws IOException {
            super(in);
            this.totalNanoseconds = in.readZLong();
        }

        public TimedCounter add(TimedCounter counter) {
            return new TimedCounter(this.count + counter.count, this.total + counter.total, Math.min(this.min, counter.min), Math.max(this.max, counter.max), this.totalNanoseconds + counter.totalNanoseconds);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeZLong(this.totalNanoseconds);
        }

        @Override
        void innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (builder.humanReadable()) {
                builder.field("time", TimeValue.timeValueNanos((long)this.totalNanoseconds).toString());
            }
            builder.field("time_in_nanos", this.totalNanoseconds);
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            if (!super.equals(other)) {
                return false;
            }
            TimedCounter that = (TimedCounter)other;
            return this.totalNanoseconds == that.totalNanoseconds;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.totalNanoseconds);
        }
    }

    public static class Counter
    implements Writeable,
    ToXContentObject {
        protected final long count;
        protected final long total;
        protected final long min;
        protected final long max;

        public Counter(long count, long total, long min, long max) {
            this.count = count;
            this.total = total;
            this.min = min;
            this.max = max;
        }

        Counter(StreamInput in) throws IOException {
            this.count = in.readZLong();
            this.total = in.readZLong();
            this.min = in.readZLong();
            this.max = in.readZLong();
        }

        public Counter add(Counter counter) {
            return new Counter(this.count + counter.count, this.total + counter.total, Math.min(this.min, counter.min), Math.max(this.max, counter.max));
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeZLong(this.count);
            out.writeZLong(this.total);
            out.writeZLong(this.min);
            out.writeZLong(this.max);
        }

        public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("count", this.count);
            builder.field("sum", this.total);
            builder.field("min", this.min);
            builder.field("max", this.max);
            this.innerToXContent(builder, params);
            builder.endObject();
            return builder;
        }

        void innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        }

        public long getCount() {
            return this.count;
        }

        public long getTotal() {
            return this.total;
        }

        public long getMin() {
            return this.min;
        }

        public long getMax() {
            return this.max;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Counter that = (Counter)other;
            return this.count == that.count && this.total == that.total && this.min == that.min && this.max == that.max;
        }

        public int hashCode() {
            return Objects.hash(this.count, this.total, this.min, this.max);
        }
    }
}

