/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.node.Node;
import org.elasticsearch.search.internal.ReaderContext;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.support.AuthenticationContextSerializer;
import org.elasticsearch.xpack.core.security.authc.support.SecondaryAuthentication;
import org.elasticsearch.xpack.core.security.authz.AuthorizationEngine;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.core.security.user.SystemUser;
import org.elasticsearch.xpack.core.security.user.User;

public class SecurityContext {
    private static final Logger logger = LogManager.getLogger(SecurityContext.class);
    private final ThreadContext threadContext;
    private final AuthenticationContextSerializer authenticationSerializer;
    private final String nodeName;

    public SecurityContext(Settings settings, ThreadContext threadContext) {
        this.threadContext = threadContext;
        this.authenticationSerializer = new AuthenticationContextSerializer();
        this.nodeName = (String)Node.NODE_NAME_SETTING.get(settings);
    }

    public User requireUser() {
        User user = this.getUser();
        if (user == null) {
            throw new ElasticsearchSecurityException("there is no user available in the current context", new Object[0]);
        }
        return user;
    }

    @Nullable
    public User getUser() {
        Authentication authentication = this.getAuthentication();
        return authentication == null ? null : authentication.getEffectiveSubject().getUser();
    }

    @Nullable
    public Authentication getAuthentication() {
        try {
            return this.authenticationSerializer.readFromContext(this.threadContext);
        }
        catch (IOException e) {
            logger.error("failed to read authentication", (Throwable)e);
            throw new UncheckedIOException(e);
        }
    }

    public AuthorizationEngine.AuthorizationInfo getAuthorizationInfoFromContext() {
        return Objects.requireNonNull((AuthorizationEngine.AuthorizationInfo)this.threadContext.getTransient("_authz_info"), "authorization info is missing from context");
    }

    @Nullable
    public AuthorizationEngine.ParentActionAuthorization getParentAuthorization() {
        try {
            return AuthorizationEngine.ParentActionAuthorization.readFromThreadContext(this.threadContext);
        }
        catch (IOException e) {
            logger.error("failed to read parent authorization from thread context", (Throwable)e);
            throw new UncheckedIOException(e);
        }
    }

    public void setParentAuthorization(AuthorizationEngine.ParentActionAuthorization parentAuthorization) {
        try {
            parentAuthorization.writeToThreadContext(this.threadContext);
        }
        catch (IOException e) {
            throw new AssertionError("failed to write parent authorization to the thread context", e);
        }
    }

    public SecondaryAuthentication getSecondaryAuthentication() {
        try {
            return SecondaryAuthentication.readFromContext(this);
        }
        catch (IOException e) {
            logger.error("failed to read secondary authentication", (Throwable)e);
            throw new UncheckedIOException(e);
        }
    }

    public ThreadContext getThreadContext() {
        return this.threadContext;
    }

    public void putIndicesAccessControl(@Nullable IndicesAccessControl indicesAccessControl) {
        if (indicesAccessControl != null) {
            if (!indicesAccessControl.isGranted()) {
                throw new IllegalStateException("Unexpected unauthorized access control :" + indicesAccessControl);
            }
            this.threadContext.putTransient("_indices_permissions", (Object)indicesAccessControl);
        }
    }

    public void copyIndicesAccessControlToReaderContext(ReaderContext readerContext) {
        IndicesAccessControl indicesAccessControl = (IndicesAccessControl)this.getThreadContext().getTransient("_indices_permissions");
        assert (indicesAccessControl != null) : "thread context does not contain index access control";
        readerContext.putInContext("_indices_permissions", (Object)indicesAccessControl);
    }

    public void copyIndicesAccessControlFromReaderContext(ReaderContext readerContext) {
        IndicesAccessControl scrollIndicesAccessControl = (IndicesAccessControl)readerContext.getFromContext("_indices_permissions");
        assert (scrollIndicesAccessControl != null) : "scroll does not contain index access control";
        this.getThreadContext().putTransient("_indices_permissions", (Object)scrollIndicesAccessControl);
    }

    public void setInternalUser(User internalUser, TransportVersion version) {
        assert (User.isInternal(internalUser));
        this.setAuthentication(Authentication.newInternalAuthentication(internalUser, version, this.nodeName));
    }

    public void executeAsInternalUser(User internalUser, TransportVersion version, Consumer<ThreadContext.StoredContext> consumer) {
        assert (User.isInternal(internalUser));
        ThreadContext.StoredContext original = this.threadContext.newStoredContextPreservingResponseHeaders();
        try (ThreadContext.StoredContext ignore = this.threadContext.stashContext();){
            this.setInternalUser(internalUser, version);
            consumer.accept(original);
        }
    }

    public void executeAsSystemUser(Consumer<ThreadContext.StoredContext> consumer) {
        this.executeAsSystemUser(TransportVersion.CURRENT, consumer);
    }

    public void executeAsSystemUser(TransportVersion version, Consumer<ThreadContext.StoredContext> consumer) {
        this.executeAsInternalUser(SystemUser.INSTANCE, version, consumer);
    }

    public <T> T executeWithAuthentication(Authentication authentication, Function<ThreadContext.StoredContext, T> consumer) {
        ThreadContext.StoredContext original = this.threadContext.newStoredContextPreservingResponseHeaders();
        try (ThreadContext.StoredContext ignore = this.threadContext.stashContext();){
            this.setAuthentication(authentication);
            T t = consumer.apply(original);
            return t;
        }
    }

    public void executeAfterRewritingAuthentication(Consumer<ThreadContext.StoredContext> consumer, TransportVersion version) {
        Map existingRequestHeaders = this.threadContext.getRequestHeadersOnly();
        ThreadContext.StoredContext original = this.threadContext.newStoredContextPreservingResponseHeaders();
        Authentication authentication = this.getAuthentication();
        try (ThreadContext.StoredContext ignore = this.threadContext.stashContext();){
            this.setAuthentication(authentication.maybeRewriteForOlderVersion(version));
            existingRequestHeaders.forEach((k, v) -> {
                if (this.threadContext.getHeader(k) == null) {
                    this.threadContext.putHeader(k, v);
                }
            });
            consumer.accept(original);
        }
    }

    public void executeAfterRemovingParentAuthorization(Consumer<ThreadContext.StoredContext> consumer) {
        try (ThreadContext.StoredContext original = this.threadContext.newStoredContextPreservingResponseHeaders(List.of(), List.of("_xpack_security_parent_action_authz"));){
            consumer.accept(original);
        }
    }

    public boolean canIAccessResourcesCreatedBy(@Nullable Authentication resourceCreatorAuthentication) {
        if (resourceCreatorAuthentication == null) {
            return true;
        }
        Authentication myAuthentication = this.getAuthentication();
        if (myAuthentication == null) {
            return false;
        }
        return myAuthentication.canAccessResourcesOf(resourceCreatorAuthentication);
    }

    public boolean canIAccessResourcesCreatedWithHeaders(Map<String, String> resourceCreateRequestHeaders) throws IOException {
        Authentication resourceCreatorAuthentication = null;
        if (resourceCreateRequestHeaders != null && resourceCreateRequestHeaders.containsKey("_xpack_security_authentication")) {
            resourceCreatorAuthentication = AuthenticationContextSerializer.decode(resourceCreateRequestHeaders.get("_xpack_security_authentication"));
        }
        return this.canIAccessResourcesCreatedBy(resourceCreatorAuthentication);
    }

    private void setAuthentication(Authentication authentication) {
        try {
            authentication.writeToContext(this.threadContext);
        }
        catch (IOException e) {
            throw new AssertionError("how can we have a IOException with a user we set", e);
        }
    }
}

