/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.apikey;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;

public final class GetApiKeyRequest
extends ActionRequest {
    private final String realmName;
    private final String userName;
    private final String apiKeyId;
    private final String apiKeyName;
    private final boolean ownedByAuthenticatedUser;
    private final boolean withLimitedBy;

    public GetApiKeyRequest(StreamInput in) throws IOException {
        super(in);
        this.realmName = GetApiKeyRequest.textOrNull(in.readOptionalString());
        this.userName = GetApiKeyRequest.textOrNull(in.readOptionalString());
        this.apiKeyId = GetApiKeyRequest.textOrNull(in.readOptionalString());
        this.apiKeyName = GetApiKeyRequest.textOrNull(in.readOptionalString());
        this.ownedByAuthenticatedUser = in.getTransportVersion().onOrAfter(TransportVersion.V_7_4_0) ? in.readOptionalBoolean() : false;
        this.withLimitedBy = in.getTransportVersion().onOrAfter(TransportVersion.V_8_5_0) ? in.readBoolean() : false;
    }

    private GetApiKeyRequest(@Nullable String realmName, @Nullable String userName, @Nullable String apiKeyId, @Nullable String apiKeyName, boolean ownedByAuthenticatedUser, boolean withLimitedBy) {
        this.realmName = GetApiKeyRequest.textOrNull(realmName);
        this.userName = GetApiKeyRequest.textOrNull(userName);
        this.apiKeyId = GetApiKeyRequest.textOrNull(apiKeyId);
        this.apiKeyName = GetApiKeyRequest.textOrNull(apiKeyName);
        this.ownedByAuthenticatedUser = ownedByAuthenticatedUser;
        this.withLimitedBy = withLimitedBy;
    }

    private static String textOrNull(@Nullable String arg) {
        return Strings.hasText((String)arg) ? arg : null;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getApiKeyId() {
        return this.apiKeyId;
    }

    public String getApiKeyName() {
        return this.apiKeyName;
    }

    public boolean ownedByAuthenticatedUser() {
        return this.ownedByAuthenticatedUser;
    }

    public boolean withLimitedBy() {
        return this.withLimitedBy;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if ((Strings.hasText((String)this.apiKeyId) || Strings.hasText((String)this.apiKeyName)) && (Strings.hasText((String)this.realmName) || Strings.hasText((String)this.userName))) {
            validationException = ValidateActions.addValidationError((String)"username or realm name must not be specified when the api key id or api key name is specified", validationException);
        }
        if (this.ownedByAuthenticatedUser && (Strings.hasText((String)this.realmName) || Strings.hasText((String)this.userName))) {
            validationException = ValidateActions.addValidationError((String)"neither username nor realm-name may be specified when retrieving owned API keys", (ActionRequestValidationException)validationException);
        }
        if (Strings.hasText((String)this.apiKeyId) && Strings.hasText((String)this.apiKeyName)) {
            validationException = ValidateActions.addValidationError((String)"only one of [api key id, api key name] can be specified", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.realmName);
        out.writeOptionalString(this.userName);
        out.writeOptionalString(this.apiKeyId);
        out.writeOptionalString(this.apiKeyName);
        if (out.getTransportVersion().onOrAfter(TransportVersion.V_7_4_0)) {
            out.writeOptionalBoolean(Boolean.valueOf(this.ownedByAuthenticatedUser));
        }
        if (out.getTransportVersion().onOrAfter(TransportVersion.V_8_5_0)) {
            out.writeBoolean(this.withLimitedBy);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GetApiKeyRequest that = (GetApiKeyRequest)((Object)o);
        return this.ownedByAuthenticatedUser == that.ownedByAuthenticatedUser && Objects.equals(this.realmName, that.realmName) && Objects.equals(this.userName, that.userName) && Objects.equals(this.apiKeyId, that.apiKeyId) && Objects.equals(this.apiKeyName, that.apiKeyName) && this.withLimitedBy == that.withLimitedBy;
    }

    public int hashCode() {
        return Objects.hash(this.realmName, this.userName, this.apiKeyId, this.apiKeyName, this.ownedByAuthenticatedUser, this.withLimitedBy);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String realmName = null;
        private String userName = null;
        private String apiKeyId = null;
        private String apiKeyName = null;
        private boolean ownedByAuthenticatedUser = false;
        private boolean withLimitedBy = false;

        public Builder realmName(String realmName) {
            this.realmName = realmName;
            return this;
        }

        public Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public Builder apiKeyId(String apiKeyId) {
            this.apiKeyId = apiKeyId;
            return this;
        }

        public Builder apiKeyName(String apiKeyName) {
            this.apiKeyName = apiKeyName;
            return this;
        }

        public Builder ownedByAuthenticatedUser() {
            return this.ownedByAuthenticatedUser(true);
        }

        public Builder ownedByAuthenticatedUser(boolean ownedByAuthenticatedUser) {
            this.ownedByAuthenticatedUser = ownedByAuthenticatedUser;
            return this;
        }

        public Builder withLimitedBy() {
            return this.withLimitedBy(true);
        }

        public Builder withLimitedBy(boolean withLimitedBy) {
            this.withLimitedBy = withLimitedBy;
            return this;
        }

        public GetApiKeyRequest build() {
            return new GetApiKeyRequest(this.realmName, this.userName, this.apiKeyId, this.apiKeyName, this.ownedByAuthenticatedUser, this.withLimitedBy);
        }
    }
}

