/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.apikey;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.security.action.apikey.BaseUpdateApiKeyRequest;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;

public final class UpdateApiKeyRequest
extends BaseUpdateApiKeyRequest {
    private final String id;

    public static UpdateApiKeyRequest usingApiKeyId(String id) {
        return new UpdateApiKeyRequest(id, null, null);
    }

    public UpdateApiKeyRequest(String id, @Nullable List<RoleDescriptor> roleDescriptors, @Nullable Map<String, Object> metadata) {
        super(roleDescriptors, metadata);
        this.id = Objects.requireNonNull(id, "API key ID must not be null");
    }

    public UpdateApiKeyRequest(StreamInput in) throws IOException {
        super(in);
        this.id = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.id);
    }

    public String getId() {
        return this.id;
    }
}

