/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.oidc;

import java.io.IOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class OpenIdConnectAuthenticateRequest
extends ActionRequest {
    private String redirectUri;
    private String state;
    private String nonce;
    private String realm;

    public OpenIdConnectAuthenticateRequest() {
    }

    public OpenIdConnectAuthenticateRequest(StreamInput in) throws IOException {
        super(in);
        this.redirectUri = in.readString();
        this.state = in.readString();
        this.nonce = in.readString();
        if (in.getTransportVersion().onOrAfter(TransportVersion.V_7_4_0)) {
            this.realm = in.readOptionalString();
        }
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (Strings.isNullOrEmpty((String)this.state)) {
            validationException = ValidateActions.addValidationError((String)"state parameter is missing", validationException);
        }
        if (Strings.isNullOrEmpty((String)this.nonce)) {
            validationException = ValidateActions.addValidationError((String)"nonce parameter is missing", (ActionRequestValidationException)validationException);
        }
        if (Strings.isNullOrEmpty((String)this.redirectUri)) {
            validationException = ValidateActions.addValidationError((String)"redirect_uri parameter is missing", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.redirectUri);
        out.writeString(this.state);
        out.writeString(this.nonce);
        if (out.getTransportVersion().onOrAfter(TransportVersion.V_7_4_0)) {
            out.writeOptionalString(this.realm);
        }
    }

    public String toString() {
        return "{redirectUri=" + this.redirectUri + ", state=" + this.state + ", nonce=" + this.nonce + ", realm=" + this.realm + "}";
    }
}

