/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.user;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.WriteRequestBuilder;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.security.action.user.PutUserAction;
import org.elasticsearch.xpack.core.security.action.user.PutUserRequest;
import org.elasticsearch.xpack.core.security.action.user.PutUserResponse;
import org.elasticsearch.xpack.core.security.authc.support.Hasher;
import org.elasticsearch.xpack.core.security.support.Validation;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.core.security.xcontent.XContentUtils;

public class PutUserRequestBuilder
extends ActionRequestBuilder<PutUserRequest, PutUserResponse>
implements WriteRequestBuilder<PutUserRequestBuilder> {
    public PutUserRequestBuilder(ElasticsearchClient client) {
        this(client, PutUserAction.INSTANCE);
    }

    public PutUserRequestBuilder(ElasticsearchClient client, PutUserAction action) {
        super(client, (ActionType)action, (ActionRequest)new PutUserRequest());
    }

    public PutUserRequestBuilder username(String username) {
        ((PutUserRequest)this.request).username(username);
        return this;
    }

    public PutUserRequestBuilder roles(String ... roles) {
        ((PutUserRequest)this.request).roles(roles);
        return this;
    }

    @Deprecated
    public PutUserRequestBuilder password(char[] password, Hasher hasher) {
        return this.password(new SecureString(password), hasher);
    }

    public PutUserRequestBuilder password(SecureString password, Hasher hasher) {
        if (password != null) {
            Validation.Error error = Validation.Users.validatePassword(password);
            if (error != null) {
                throw PutUserRequestBuilder.validationException(error.toString());
            }
            if (((PutUserRequest)this.request).passwordHash() != null) {
                throw PutUserRequestBuilder.validationException("password_hash has already been set");
            }
            ((PutUserRequest)this.request).passwordHash(hasher.hash(password));
        } else {
            ((PutUserRequest)this.request).passwordHash(null);
        }
        return this;
    }

    public PutUserRequestBuilder metadata(Map<String, Object> metadata) {
        ((PutUserRequest)this.request).metadata(metadata);
        return this;
    }

    public PutUserRequestBuilder fullName(String fullName) {
        ((PutUserRequest)this.request).fullName(fullName);
        return this;
    }

    public PutUserRequestBuilder email(String email) {
        ((PutUserRequest)this.request).email(email);
        return this;
    }

    public PutUserRequestBuilder passwordHash(char[] passwordHash, Hasher configuredHasher) {
        Hasher resolvedHasher = Hasher.resolveFromHash(passwordHash);
        if (!resolvedHasher.equals((Object)configuredHasher) && !Hasher.getAvailableAlgoStoredHash().contains(resolvedHasher.name().toLowerCase(Locale.ROOT))) {
            throw new IllegalArgumentException("The provided password hash is not a hash or it could not be resolved to a supported hash algorithm. The supported password hash algorithms are " + Hasher.getAvailableAlgoStoredHash().toString());
        }
        if (((PutUserRequest)this.request).passwordHash() != null) {
            throw PutUserRequestBuilder.validationException("password_hash has already been set");
        }
        ((PutUserRequest)this.request).passwordHash(passwordHash);
        return this;
    }

    public PutUserRequestBuilder enabled(boolean enabled) {
        ((PutUserRequest)this.request).enabled(enabled);
        return this;
    }

    public PutUserRequestBuilder source(String username, BytesReference source, XContentType xContentType, Hasher hasher) throws IOException {
        Objects.requireNonNull(xContentType);
        this.username(username);
        try (StreamInput stream = source.streamInput();){
            PutUserRequestBuilder putUserRequestBuilder;
            block35: {
                XContentParser parser = xContentType.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);
                try {
                    XContentParser.Token token;
                    XContentUtils.verifyObject(parser);
                    String currentFieldName = null;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (User.Fields.PASSWORD.match(currentFieldName, parser.getDeprecationHandler())) {
                            if (token == XContentParser.Token.VALUE_STRING) {
                                String password = parser.text();
                                SecureString securePassword = new SecureString(password.toCharArray());
                                try {
                                    this.password(securePassword, hasher);
                                    continue;
                                }
                                finally {
                                    securePassword.close();
                                    continue;
                                }
                            }
                            throw new ElasticsearchParseException("expected field [{}] to be of type string, but found [{}] instead", new Object[]{currentFieldName, token});
                        }
                        if (User.Fields.PASSWORD_HASH.match(currentFieldName, parser.getDeprecationHandler())) {
                            if (token == XContentParser.Token.VALUE_STRING) {
                                char[] passwordChars = parser.text().toCharArray();
                                this.passwordHash(passwordChars, hasher);
                                continue;
                            }
                            throw new ElasticsearchParseException("expected field [{}] to be of type string, but found [{}] instead", new Object[]{currentFieldName, token});
                        }
                        if (User.Fields.ROLES.match(currentFieldName, parser.getDeprecationHandler())) {
                            if (token == XContentParser.Token.VALUE_STRING) {
                                this.roles(Strings.commaDelimitedListToStringArray((String)parser.text()));
                                continue;
                            }
                            this.roles(XContentUtils.readStringArray(parser, false));
                            continue;
                        }
                        if (User.Fields.FULL_NAME.match(currentFieldName, parser.getDeprecationHandler())) {
                            if (token == XContentParser.Token.VALUE_STRING) {
                                this.fullName(parser.text());
                                continue;
                            }
                            if (token == XContentParser.Token.VALUE_NULL) continue;
                            throw new ElasticsearchParseException("expected field [{}] to be of type string, but found [{}] instead", new Object[]{currentFieldName, token});
                        }
                        if (User.Fields.EMAIL.match(currentFieldName, parser.getDeprecationHandler())) {
                            if (token == XContentParser.Token.VALUE_STRING) {
                                this.email(parser.text());
                                continue;
                            }
                            if (token == XContentParser.Token.VALUE_NULL) continue;
                            throw new ElasticsearchParseException("expected field [{}] to be of type string, but found [{}] instead", new Object[]{currentFieldName, token});
                        }
                        if (User.Fields.METADATA.match(currentFieldName, parser.getDeprecationHandler())) {
                            if (token == XContentParser.Token.START_OBJECT) {
                                this.metadata(parser.map());
                                continue;
                            }
                            throw new ElasticsearchParseException("expected field [{}] to be of type object, but found [{}] instead", new Object[]{currentFieldName, token});
                        }
                        if (User.Fields.ENABLED.match(currentFieldName, parser.getDeprecationHandler())) {
                            if (token == XContentParser.Token.VALUE_BOOLEAN) {
                                this.enabled(parser.booleanValue());
                                continue;
                            }
                            throw new ElasticsearchParseException("expected field [{}] to be of type boolean, but found [{}] instead", new Object[]{currentFieldName, token});
                        }
                        if (User.Fields.USERNAME.match(currentFieldName, parser.getDeprecationHandler())) {
                            if (token == XContentParser.Token.VALUE_STRING) {
                                if (username.equals(parser.text())) continue;
                                throw new IllegalArgumentException("[username] in source does not match the username provided [" + username + "]");
                            }
                            throw new ElasticsearchParseException("expected field [{}] to be of type string, but found [{}] instead", new Object[]{currentFieldName, token});
                        }
                        throw new ElasticsearchParseException("failed to parse add user request. unexpected field [{}]", new Object[]{currentFieldName});
                    }
                    putUserRequestBuilder = this;
                    if (parser == null) break block35;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return putUserRequestBuilder;
        }
    }

    private static ValidationException validationException(String abc) {
        ValidationException validationException = new ValidationException();
        validationException.addValidationError(abc);
        return validationException;
    }
}

