/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.util.ArrayUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RemoteAccessAuthentication;
import org.elasticsearch.xpack.core.security.authz.store.RoleReference;
import org.elasticsearch.xpack.core.security.authz.store.RoleReferenceIntersection;
import org.elasticsearch.xpack.core.security.user.AnonymousUser;
import org.elasticsearch.xpack.core.security.user.User;

public class Subject {
    private final TransportVersion version;
    private final User user;
    private final Authentication.RealmRef realm;
    private final Type type;
    private final Map<String, Object> metadata;
    static final BytesArray FLEET_SERVER_ROLE_DESCRIPTOR_BYTES_V_7_14 = new BytesArray("{\"elastic/fleet-server\":{\"cluster\":[\"monitor\",\"manage_own_api_key\"],\"indices\":[{\"names\":[\"logs-*\",\"metrics-*\",\"traces-*\",\"synthetics-*\",\".logs-endpoint.diagnostic.collection-*\"],\"privileges\":[\"write\",\"create_index\",\"auto_configure\"],\"allow_restricted_indices\":false},{\"names\":[\".fleet-*\"],\"privileges\":[\"read\",\"write\",\"monitor\",\"create_index\",\"auto_configure\"],\"allow_restricted_indices\":false}],\"applications\":[],\"run_as\":[],\"metadata\":{},\"transient_metadata\":{\"enabled\":true}}}");

    public Subject(User user, Authentication.RealmRef realm) {
        this(user, realm, TransportVersion.CURRENT, Map.of());
    }

    public Subject(User user, Authentication.RealmRef realm, TransportVersion version, Map<String, Object> metadata) {
        this.version = version;
        this.user = user;
        this.realm = realm;
        if (realm == null) {
            this.type = Type.USER;
        } else if ("_es_api_key".equals(realm.getType())) {
            assert ("_es_api_key".equals(realm.getName())) : "api key realm name mismatch";
            this.type = Type.API_KEY;
        } else if ("_service_account".equals(realm.getType())) {
            assert ("_service_account".equals(realm.getName())) : "service account realm name mismatch";
            this.type = Type.SERVICE_ACCOUNT;
        } else if ("_es_remote_access".equals(realm.getType())) {
            assert ("_es_remote_access".equals(realm.getName())) : "remote access realm name mismatch";
            this.type = Type.REMOTE_ACCESS;
        } else {
            this.type = Type.USER;
        }
        this.metadata = metadata;
    }

    public User getUser() {
        return this.user;
    }

    public Authentication.RealmRef getRealm() {
        return this.realm;
    }

    public Type getType() {
        return this.type;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public TransportVersion getTransportVersion() {
        return this.version;
    }

    public RoleReferenceIntersection getRoleReferenceIntersection(@Nullable AnonymousUser anonymousUser) {
        switch (this.type) {
            case USER: {
                return this.buildRoleReferencesForUser(anonymousUser);
            }
            case API_KEY: {
                return this.buildRoleReferencesForApiKey();
            }
            case SERVICE_ACCOUNT: {
                return new RoleReferenceIntersection(new RoleReference.ServiceAccountRoleReference(this.user.principal()));
            }
            case REMOTE_ACCESS: {
                return this.buildRoleReferencesForRemoteAccess();
            }
        }
        assert (false) : "unknown subject type: [" + this.type + "]";
        throw new IllegalStateException("unknown subject type: [" + this.type + "]");
    }

    public boolean canAccessResourcesOf(Subject resourceCreatorSubject) {
        if (Type.API_KEY.equals((Object)this.getType()) && Type.API_KEY.equals((Object)resourceCreatorSubject.getType())) {
            boolean sameKeyId = this.getMetadata().get("_security_api_key_id").equals(resourceCreatorSubject.getMetadata().get("_security_api_key_id"));
            assert (!sameKeyId || this.getUser().principal().equals(resourceCreatorSubject.getUser().principal())) : "The same API key ID cannot be attributed to two different usernames";
            return sameKeyId;
        }
        if (Type.API_KEY.equals((Object)this.getType()) && !Type.API_KEY.equals((Object)resourceCreatorSubject.getType()) || !Type.API_KEY.equals((Object)this.getType()) && Type.API_KEY.equals((Object)resourceCreatorSubject.getType())) {
            return false;
        }
        if (Type.REMOTE_ACCESS.equals((Object)this.getType()) || Type.REMOTE_ACCESS.equals((Object)resourceCreatorSubject.getType())) {
            return false;
        }
        if (!this.getUser().principal().equals(resourceCreatorSubject.getUser().principal())) {
            return false;
        }
        Authentication.RealmRef myAuthRealm = this.getRealm();
        Authentication.RealmRef creatorAuthRealm = resourceCreatorSubject.getRealm();
        if (null == myAuthRealm.getDomain()) {
            return Authentication.equivalentRealms(myAuthRealm.getName(), myAuthRealm.getType(), creatorAuthRealm.getName(), creatorAuthRealm.getType());
        }
        for (RealmConfig.RealmIdentifier domainRealm : myAuthRealm.getDomain().realms()) {
            if (!Authentication.equivalentRealms(domainRealm.getName(), domainRealm.getType(), creatorAuthRealm.getName(), creatorAuthRealm.getType())) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subject subject = (Subject)o;
        return this.version.equals((Object)subject.version) && this.user.equals(subject.user) && Objects.equals(this.realm, subject.realm) && this.type == subject.type && this.metadata.equals(subject.metadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.version, this.user, this.realm, this.type, this.metadata});
    }

    public String toString() {
        return "Subject{version=" + this.version + ", user=" + this.user + ", realm=" + this.realm + ", type=" + this.type + ", metadata=" + this.metadata + "}";
    }

    private RoleReferenceIntersection buildRoleReferencesForUser(AnonymousUser anonymousUser) {
        String[] allRoleNames;
        if (this.user.equals(anonymousUser)) {
            return new RoleReferenceIntersection(new RoleReference.NamedRoleReference(this.user.roles()));
        }
        if (anonymousUser == null || !anonymousUser.enabled()) {
            allRoleNames = this.user.roles();
        } else {
            if (anonymousUser.roles().length == 0) {
                throw new IllegalStateException("anonymous is only enabled when the anonymous user has roles");
            }
            allRoleNames = ArrayUtils.concat((String[])this.user.roles(), (String[])anonymousUser.roles());
        }
        return new RoleReferenceIntersection(new RoleReference.NamedRoleReference(allRoleNames));
    }

    private RoleReferenceIntersection buildRoleReferencesForApiKey() {
        if (this.version.before(Authentication.VERSION_API_KEY_ROLES_AS_BYTES)) {
            return this.buildRolesReferenceForApiKeyBwc();
        }
        String apiKeyId = (String)this.metadata.get("_security_api_key_id");
        BytesReference roleDescriptorsBytes = (BytesReference)this.metadata.get("_security_api_key_role_descriptors");
        BytesReference limitedByRoleDescriptorsBytes = this.getLimitedByRoleDescriptorsBytes();
        if (roleDescriptorsBytes == null && limitedByRoleDescriptorsBytes == null) {
            throw new ElasticsearchSecurityException("no role descriptors found for API key", new Object[0]);
        }
        RoleReference.ApiKeyRoleReference limitedByRoleReference = new RoleReference.ApiKeyRoleReference(apiKeyId, limitedByRoleDescriptorsBytes, RoleReference.ApiKeyRoleType.LIMITED_BY);
        if (Subject.isEmptyRoleDescriptorsBytes(roleDescriptorsBytes)) {
            return new RoleReferenceIntersection(limitedByRoleReference);
        }
        return new RoleReferenceIntersection(new RoleReference.ApiKeyRoleReference(apiKeyId, roleDescriptorsBytes, RoleReference.ApiKeyRoleType.ASSIGNED), limitedByRoleReference);
    }

    private RoleReferenceIntersection buildRoleReferencesForRemoteAccess() {
        ArrayList<RoleReference> roleReferences = new ArrayList<RoleReference>(4);
        List remoteAccessRoleDescriptorsBytes = (List)this.metadata.get("_security_remote_access_role_descriptors");
        if (remoteAccessRoleDescriptorsBytes.isEmpty()) {
            roleReferences.add(new RoleReference.RemoteAccessRoleReference(RemoteAccessAuthentication.RoleDescriptorsBytes.EMPTY));
        } else {
            assert (remoteAccessRoleDescriptorsBytes.size() == 1) : "only a singleton list of remote access role descriptors bytes is supported";
            for (RemoteAccessAuthentication.RoleDescriptorsBytes roleDescriptorsBytes : remoteAccessRoleDescriptorsBytes) {
                roleReferences.add(new RoleReference.RemoteAccessRoleReference(roleDescriptorsBytes));
            }
        }
        roleReferences.addAll(this.buildRoleReferencesForApiKey().getRoleReferences());
        return new RoleReferenceIntersection(List.copyOf(roleReferences));
    }

    private static boolean isEmptyRoleDescriptorsBytes(BytesReference roleDescriptorsBytes) {
        return roleDescriptorsBytes == null || roleDescriptorsBytes.length() == 2 && "{}".equals(roleDescriptorsBytes.utf8ToString());
    }

    private RoleReferenceIntersection buildRolesReferenceForApiKeyBwc() {
        String apiKeyId = (String)this.metadata.get("_security_api_key_id");
        Map<String, Object> roleDescriptorsMap = this.getRoleDescriptorMap("_security_api_key_role_descriptors");
        Map<String, Object> limitedByRoleDescriptorsMap = this.getRoleDescriptorMap("_security_api_key_limited_by_role_descriptors");
        if (roleDescriptorsMap == null && limitedByRoleDescriptorsMap == null) {
            throw new ElasticsearchSecurityException("no role descriptors found for API key", new Object[0]);
        }
        RoleReference.BwcApiKeyRoleReference limitedByRoleReference = new RoleReference.BwcApiKeyRoleReference(apiKeyId, limitedByRoleDescriptorsMap, RoleReference.ApiKeyRoleType.LIMITED_BY);
        if (roleDescriptorsMap == null || roleDescriptorsMap.isEmpty()) {
            return new RoleReferenceIntersection(limitedByRoleReference);
        }
        return new RoleReferenceIntersection(new RoleReference.BwcApiKeyRoleReference(apiKeyId, roleDescriptorsMap, RoleReference.ApiKeyRoleType.ASSIGNED), limitedByRoleReference);
    }

    private Map<String, Object> getRoleDescriptorMap(String key) {
        return (Map)this.metadata.get(key);
    }

    private BytesReference getLimitedByRoleDescriptorsBytes() {
        BytesReference bytesReference = (BytesReference)this.metadata.get("_security_api_key_limited_by_role_descriptors");
        if (bytesReference.length() == 2 && "{}".equals(bytesReference.utf8ToString()) && "_service_account".equals(this.metadata.get("_security_api_key_creator_realm_name")) && "elastic/fleet-server".equals(this.user.principal())) {
            return FLEET_SERVER_ROLE_DESCRIPTOR_BYTES_V_7_14;
        }
        return bytesReference;
    }

    public static enum Type {
        USER,
        API_KEY,
        SERVICE_ACCOUNT,
        REMOTE_ACCESS;

    }
}

