/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.jwt;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.support.ClaimSetting;
import org.elasticsearch.xpack.core.security.authc.support.DelegatedAuthorizationSettings;
import org.elasticsearch.xpack.core.ssl.SSLConfigurationSettings;

public class JwtRealmSettings {
    public static final String TYPE = "jwt";
    public static final List<String> SUPPORTED_SIGNATURE_ALGORITHMS_HMAC = List.of("HS256", "HS384", "HS512");
    public static final List<String> SUPPORTED_SIGNATURE_ALGORITHMS_RSA = List.of("RS256", "RS384", "RS512", "PS256", "PS384", "PS512");
    public static final List<String> SUPPORTED_SIGNATURE_ALGORITHMS_EC = List.of("ES256", "ES384", "ES512");
    public static final List<String> SUPPORTED_SIGNATURE_ALGORITHMS_PKC = Stream.of(SUPPORTED_SIGNATURE_ALGORITHMS_RSA, SUPPORTED_SIGNATURE_ALGORITHMS_EC).flatMap(Collection::stream).toList();
    public static final List<String> SUPPORTED_SIGNATURE_ALGORITHMS = Stream.of(SUPPORTED_SIGNATURE_ALGORITHMS_HMAC, SUPPORTED_SIGNATURE_ALGORITHMS_PKC).flatMap(Collection::stream).toList();
    private static final TimeValue DEFAULT_ALLOWED_CLOCK_SKEW = TimeValue.timeValueSeconds((long)60L);
    private static final List<String> DEFAULT_ALLOWED_SIGNATURE_ALGORITHMS = Collections.singletonList("RS256");
    private static final boolean DEFAULT_POPULATE_USER_METADATA = true;
    private static final TimeValue DEFAULT_JWT_CACHE_TTL = TimeValue.timeValueMinutes((long)20L);
    private static final int DEFAULT_JWT_CACHE_SIZE = 100000;
    private static final int MIN_JWT_CACHE_SIZE = 0;
    private static final TimeValue DEFAULT_HTTP_CONNECT_TIMEOUT = TimeValue.timeValueSeconds((long)5L);
    private static final TimeValue DEFAULT_HTTP_CONNECTION_READ_TIMEOUT = TimeValue.timeValueSeconds((long)5L);
    private static final TimeValue DEFAULT_HTTP_SOCKET_TIMEOUT = TimeValue.timeValueSeconds((long)5L);
    private static final int DEFAULT_HTTP_MAX_CONNECTIONS = 200;
    private static final int MIN_HTTP_MAX_CONNECTIONS = 0;
    private static final int DEFAULT_HTTP_MAX_ENDPOINT_CONNECTIONS = 200;
    private static final int MIN_HTTP_MAX_ENDPOINT_CONNECTIONS = 0;
    public static final Setting.AffixSetting<TokenType> TOKEN_TYPE = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("jwt"), (String)"token_type", key -> new Setting(key, TokenType.ID_TOKEN.value(), value -> TokenType.parse(value, key), new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<String> ALLOWED_ISSUER = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("jwt"), (String)"allowed_issuer", key -> Setting.simpleString((String)key, value -> JwtRealmSettings.verifyNonNullNotEmpty(key, value, null), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<TimeValue> ALLOWED_CLOCK_SKEW = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("jwt"), (String)"allowed_clock_skew", key -> Setting.timeSetting((String)key, (TimeValue)DEFAULT_ALLOWED_CLOCK_SKEW, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<List<String>> ALLOWED_SIGNATURE_ALGORITHMS = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("jwt"), (String)"allowed_signature_algorithms", key -> Setting.listSetting((String)key, DEFAULT_ALLOWED_SIGNATURE_ALGORITHMS, Function.identity(), values -> JwtRealmSettings.verifyNonNullNotEmpty(key, values, SUPPORTED_SIGNATURE_ALGORITHMS), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<String> PKC_JWKSET_PATH = RealmSettings.simpleString("jwt", "pkc_jwkset_path", Setting.Property.NodeScope);
    public static final Setting.AffixSetting<SecureString> HMAC_JWKSET = RealmSettings.secureString("jwt", "hmac_jwkset");
    public static final Setting.AffixSetting<SecureString> HMAC_KEY = RealmSettings.secureString("jwt", "hmac_key");
    public static final Setting.AffixSetting<List<String>> ALLOWED_AUDIENCES = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("jwt"), (String)"allowed_audiences", key -> Setting.stringListSetting((String)key, values -> JwtRealmSettings.verifyNonNullNotEmpty(key, values, null), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<List<String>> ALLOWED_SUBJECTS = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("jwt"), (String)"allowed_subjects", key -> Setting.stringListSetting((String)key, values -> JwtRealmSettings.verifyNonNullNotEmpty(key, values, null), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final List<String> REGISTERED_CLAIM_NAMES = List.of("iss", "sub", "aud", "exp", "nbf", "iat", "jti");
    public static final Setting.AffixSetting<String> FALLBACK_SUB_CLAIM = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("jwt"), (String)"fallback_claims.sub", key -> Setting.simpleString((String)key, (String)"sub", (Setting.Validator)new Setting.Validator<String>(){

        public void validate(String value) {
        }

        public void validate(String value, Map<Setting<?>, Object> settings, boolean isPresent) {
            JwtRealmSettings.validateFallbackClaimSetting(FALLBACK_SUB_CLAIM, key, value, settings, isPresent);
        }

        public Iterator<Setting<?>> settings() {
            String namespace = FALLBACK_SUB_CLAIM.getNamespace(FALLBACK_SUB_CLAIM.getConcreteSetting(key));
            List<Setting> settings = List.of(TOKEN_TYPE.getConcreteSettingForNamespace(namespace));
            return settings.iterator();
        }
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<String> FALLBACK_AUD_CLAIM = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("jwt"), (String)"fallback_claims.aud", key -> Setting.simpleString((String)key, (String)"aud", (Setting.Validator)new Setting.Validator<String>(){

        public void validate(String value) {
        }

        public void validate(String value, Map<Setting<?>, Object> settings, boolean isPresent) {
            JwtRealmSettings.validateFallbackClaimSetting(FALLBACK_AUD_CLAIM, key, value, settings, isPresent);
        }

        public Iterator<Setting<?>> settings() {
            String namespace = FALLBACK_AUD_CLAIM.getNamespace(FALLBACK_AUD_CLAIM.getConcreteSetting(key));
            List<Setting> settings = List.of(TOKEN_TYPE.getConcreteSettingForNamespace(namespace));
            return settings.iterator();
        }
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Settings> REQUIRED_CLAIMS = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("jwt"), (String)"required_claims", key -> Setting.groupSetting((String)(key + "."), settings -> {
        List<String> invalidRequiredClaims = List.of("iss", "sub", "aud", "exp", "nbf", "iat");
        for (String name : settings.names()) {
            String fullName = key + "." + name;
            if (invalidRequiredClaims.contains(name)) {
                throw new IllegalArgumentException(Strings.format((String)"required claim [%s] cannot be one of [%s]", (Object[])new Object[]{fullName, String.join((CharSequence)",", invalidRequiredClaims)}));
            }
            List values = settings.getAsList(name);
            if (!values.isEmpty()) continue;
            throw new IllegalArgumentException(Strings.format((String)"required claim [%s] cannot be empty", (Object[])new Object[]{fullName}));
        }
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final ClaimSetting CLAIMS_PRINCIPAL = new ClaimSetting("jwt", "principal");
    public static final ClaimSetting CLAIMS_GROUPS = new ClaimSetting("jwt", "groups");
    public static final ClaimSetting CLAIMS_DN = new ClaimSetting("jwt", "dn");
    public static final ClaimSetting CLAIMS_MAIL = new ClaimSetting("jwt", "mail");
    public static final ClaimSetting CLAIMS_NAME = new ClaimSetting("jwt", "name");
    public static final Setting.AffixSetting<Boolean> POPULATE_USER_METADATA = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("jwt"), (String)"populate_user_metadata", key -> Setting.boolSetting((String)key, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<ClientAuthenticationType> CLIENT_AUTHENTICATION_TYPE = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("jwt"), (String)"client_authentication.type", key -> new Setting(key, ClientAuthenticationType.SHARED_SECRET.value, value -> ClientAuthenticationType.parse(value, key), new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<SecureString> CLIENT_AUTHENTICATION_SHARED_SECRET = RealmSettings.secureString("jwt", "client_authentication.shared_secret");
    public static final Setting.AffixSetting<TimeValue> JWT_CACHE_TTL = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("jwt"), (String)"jwt.cache.ttl", key -> Setting.timeSetting((String)key, (TimeValue)DEFAULT_JWT_CACHE_TTL, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Integer> JWT_CACHE_SIZE = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("jwt"), (String)"jwt.cache.size", key -> Setting.intSetting((String)key, (int)100000, (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<TimeValue> HTTP_CONNECT_TIMEOUT = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("jwt"), (String)"http.connect_timeout", key -> Setting.timeSetting((String)key, (TimeValue)DEFAULT_HTTP_CONNECT_TIMEOUT, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<TimeValue> HTTP_CONNECTION_READ_TIMEOUT = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("jwt"), (String)"http.connection_read_timeout", key -> Setting.timeSetting((String)key, (TimeValue)DEFAULT_HTTP_CONNECTION_READ_TIMEOUT, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<TimeValue> HTTP_SOCKET_TIMEOUT = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("jwt"), (String)"http.socket_timeout", key -> Setting.timeSetting((String)key, (TimeValue)DEFAULT_HTTP_SOCKET_TIMEOUT, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Integer> HTTP_MAX_CONNECTIONS = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("jwt"), (String)"http.max_connections", key -> Setting.intSetting((String)key, (int)200, (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Integer> HTTP_MAX_ENDPOINT_CONNECTIONS = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("jwt"), (String)"http.max_endpoint_connections", key -> Setting.intSetting((String)key, (int)200, (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Collection<Setting.AffixSetting<?>> SSL_CONFIGURATION_SETTINGS = SSLConfigurationSettings.getRealmSettings("jwt");
    public static final SSLConfigurationSettings ssl = SSLConfigurationSettings.withoutPrefix(true);
    public static final Collection<Setting.AffixSetting<?>> DELEGATED_AUTHORIZATION_REALMS_SETTINGS = DelegatedAuthorizationSettings.getSettings("jwt");

    private JwtRealmSettings() {
    }

    public static Set<Setting.AffixSetting<?>> getSettings() {
        HashSet set = new HashSet();
        set.addAll(JwtRealmSettings.getNonSecureSettings());
        set.addAll(JwtRealmSettings.getSecureSettings());
        return set;
    }

    private static Set<Setting.AffixSetting<?>> getNonSecureSettings() {
        HashSet set = new HashSet(RealmSettings.getStandardSettings(TYPE));
        set.add(TOKEN_TYPE);
        set.addAll(List.of(ALLOWED_ISSUER, ALLOWED_SIGNATURE_ALGORITHMS, ALLOWED_CLOCK_SKEW, PKC_JWKSET_PATH));
        set.addAll(List.of(ALLOWED_AUDIENCES));
        set.addAll(List.of(ALLOWED_SUBJECTS, FALLBACK_SUB_CLAIM, FALLBACK_AUD_CLAIM, REQUIRED_CLAIMS, CLAIMS_PRINCIPAL.getClaim(), CLAIMS_PRINCIPAL.getPattern(), CLAIMS_GROUPS.getClaim(), CLAIMS_GROUPS.getPattern(), CLAIMS_DN.getClaim(), CLAIMS_DN.getPattern(), CLAIMS_MAIL.getClaim(), CLAIMS_MAIL.getPattern(), CLAIMS_NAME.getClaim(), CLAIMS_NAME.getPattern(), POPULATE_USER_METADATA));
        set.addAll(List.of(CLIENT_AUTHENTICATION_TYPE));
        set.addAll(List.of(JWT_CACHE_TTL, JWT_CACHE_SIZE));
        set.addAll(List.of(HTTP_CONNECT_TIMEOUT, HTTP_CONNECTION_READ_TIMEOUT, HTTP_SOCKET_TIMEOUT, HTTP_MAX_CONNECTIONS, HTTP_MAX_ENDPOINT_CONNECTIONS));
        set.addAll(SSL_CONFIGURATION_SETTINGS);
        set.addAll(DELEGATED_AUTHORIZATION_REALMS_SETTINGS);
        return set;
    }

    private static Set<Setting.AffixSetting<SecureString>> getSecureSettings() {
        return new HashSet<Setting.AffixSetting<SecureString>>(List.of(HMAC_JWKSET, HMAC_KEY, CLIENT_AUTHENTICATION_SHARED_SECRET));
    }

    private static void verifyNonNullNotEmpty(String key, String value, List<String> allowedValues) {
        assert (value != null) : "Invalid null value for [" + key + "].";
        if (value.isEmpty()) {
            throw new IllegalArgumentException("Invalid empty value for [" + key + "].");
        }
        if (allowedValues != null && !allowedValues.contains(value)) {
            throw new IllegalArgumentException("Invalid value [" + value + "] for [" + key + "]. Allowed values are " + allowedValues + ".");
        }
    }

    private static void verifyNonNullNotEmpty(String key, List<String> values, List<String> allowedValues) {
        assert (values != null) : "Invalid null list of values for [" + key + "].";
        if (values.isEmpty()) {
            if (allowedValues == null) {
                throw new IllegalArgumentException("Invalid empty list for [" + key + "].");
            }
            throw new IllegalArgumentException("Invalid empty list for [" + key + "]. Allowed values are " + allowedValues + ".");
        }
        for (String value : values) {
            JwtRealmSettings.verifyNonNullNotEmpty(key, value, allowedValues);
        }
    }

    private static void validateFallbackClaimSetting(Setting.AffixSetting<String> setting, String key, String value, Map<Setting<?>, Object> settings, boolean isPresent) {
        if (!isPresent) {
            return;
        }
        String namespace = setting.getNamespace(setting.getConcreteSetting(key));
        TokenType tokenType = (TokenType)((Object)settings.get(TOKEN_TYPE.getConcreteSettingForNamespace(namespace)));
        if (tokenType == TokenType.ID_TOKEN) {
            throw new IllegalArgumentException(Strings.format((String)"fallback claim setting [%s] is not allowed when JWT realm [%s] is [%s] type", (Object[])new Object[]{key, namespace, TokenType.ID_TOKEN.value()}));
        }
        JwtRealmSettings.verifyFallbackClaimName(key, value);
    }

    private static void verifyFallbackClaimName(String key, String fallbackClaimName) {
        String claimName = key.substring(key.lastIndexOf(".") + 1);
        JwtRealmSettings.verifyNonNullNotEmpty(key, fallbackClaimName, null);
        if (claimName.equals(fallbackClaimName)) {
            return;
        }
        if (REGISTERED_CLAIM_NAMES.contains(fallbackClaimName)) {
            throw new IllegalArgumentException(Strings.format((String)"Invalid fallback claims setting [%s]. Claim [%s] cannot fallback to a registered claim [%s]", (Object[])new Object[]{key, claimName, fallbackClaimName}));
        }
    }

    public static enum TokenType {
        ID_TOKEN("id_token"),
        ACCESS_TOKEN("access_token");

        private final String value;

        private TokenType(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public static TokenType parse(String value, String settingKey) {
            return EnumSet.allOf(TokenType.class).stream().filter(type -> type.value.equalsIgnoreCase(value)).findFirst().orElseThrow(() -> new IllegalArgumentException(Strings.format((String)"Invalid value [%s] for [%s], allowed values are [%s]", (Object[])new Object[]{value, settingKey, Stream.of(TokenType.values()).map(TokenType::value).collect(Collectors.joining(","))})));
        }
    }

    public static enum ClientAuthenticationType {
        NONE("none"),
        SHARED_SECRET("shared_secret");

        private final String value;

        private ClientAuthenticationType(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public static ClientAuthenticationType parse(String value, String settingKey) {
            for (ClientAuthenticationType type : ClientAuthenticationType.values()) {
                if (!type.value.equalsIgnoreCase(value)) continue;
                return type;
            }
            throw new IllegalArgumentException("Invalid value [" + value + "] for [" + settingKey + "], allowed values are [" + Stream.of(ClientAuthenticationType.values()).map(ClientAuthenticationType::value).collect(Collectors.joining(",")) + "]");
        }
    }
}

