/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.support;

import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;

public final class ClaimSetting {
    public static final String CLAIMS_PREFIX = "claims.";
    public static final String CLAIM_PATTERNS_PREFIX = "claim_patterns.";
    private final Setting.AffixSetting<String> claim;
    private final Setting.AffixSetting<String> pattern;

    public ClaimSetting(String realmType, String settingName) {
        if (realmType == null || realmType.isEmpty()) {
            throw new IllegalArgumentException("Invalid realm type [" + realmType + "].");
        }
        if (settingName == null || settingName.isEmpty()) {
            throw new IllegalArgumentException("Invalid claim setting name [" + settingName + "].");
        }
        this.claim = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix(realmType), (String)(CLAIMS_PREFIX + settingName), key -> Setting.simpleString((String)key, value -> ClaimSetting.verifyName(key, value), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        this.pattern = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix(realmType), (String)(CLAIM_PATTERNS_PREFIX + settingName), key -> Setting.simpleString((String)key, value -> ClaimSetting.verifyPattern(key, value), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    }

    public Collection<Setting.AffixSetting<?>> settings() {
        return List.of(this.getClaim(), this.getPattern());
    }

    public String name(RealmConfig realmConfig) {
        return this.getClaim().getConcreteSettingForNamespace(realmConfig.name()).getKey();
    }

    public Setting.AffixSetting<String> getClaim() {
        return this.claim;
    }

    public Setting.AffixSetting<String> getPattern() {
        return this.pattern;
    }

    private static void verifyName(String key, String value) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("Invalid null or empty claim name for [" + key + "].");
        }
    }

    private static void verifyPattern(String key, String value) {
        if (value != null && !value.isEmpty()) {
            try {
                Pattern.compile(value);
            }
            catch (PatternSyntaxException pse) {
                throw new IllegalArgumentException("Invalid claim value regex pattern for [" + key + "].");
            }
        }
    }
}

