/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.permission;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.util.automaton.Automaton;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.AuthorizationEngine;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.core.security.authz.permission.ApplicationPermission;
import org.elasticsearch.xpack.core.security.authz.permission.ClusterPermission;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsCache;
import org.elasticsearch.xpack.core.security.authz.permission.IndicesPermission;
import org.elasticsearch.xpack.core.security.authz.permission.RemoteIndicesPermission;
import org.elasticsearch.xpack.core.security.authz.permission.ResourcePrivilegesMap;
import org.elasticsearch.xpack.core.security.authz.permission.Role;
import org.elasticsearch.xpack.core.security.authz.permission.RunAsPermission;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilegeDescriptor;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilege;

public class SimpleRole
implements Role {
    public static final Setting<Integer> CACHE_SIZE_SETTING = Setting.intSetting((String)"xpack.security.authz.store.roles.has_privileges.cache.max_size", (int)1000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final String[] names;
    private final ClusterPermission cluster;
    private final IndicesPermission indices;
    private final ApplicationPermission application;
    private final RunAsPermission runAs;
    private final RemoteIndicesPermission remoteIndices;
    private final AtomicReference<Cache<AuthorizationEngine.PrivilegesToCheck, AuthorizationEngine.PrivilegesCheckResult>> hasPrivilegesCacheReference = new AtomicReference();

    SimpleRole(String[] names, ClusterPermission cluster, IndicesPermission indices, ApplicationPermission application, RunAsPermission runAs, RemoteIndicesPermission remoteIndices) {
        this.names = names;
        this.cluster = Objects.requireNonNull(cluster);
        this.indices = Objects.requireNonNull(indices);
        this.application = Objects.requireNonNull(application);
        this.runAs = Objects.requireNonNull(runAs);
        this.remoteIndices = Objects.requireNonNull(remoteIndices);
    }

    @Override
    public String[] names() {
        return this.names;
    }

    @Override
    public ClusterPermission cluster() {
        return this.cluster;
    }

    @Override
    public IndicesPermission indices() {
        return this.indices;
    }

    @Override
    public ApplicationPermission application() {
        return this.application;
    }

    @Override
    public RunAsPermission runAs() {
        return this.runAs;
    }

    @Override
    public RemoteIndicesPermission remoteIndices() {
        return this.remoteIndices;
    }

    @Override
    public boolean hasFieldOrDocumentLevelSecurity() {
        return this.indices.hasFieldOrDocumentLevelSecurity();
    }

    @Override
    public IndicesPermission.IsResourceAuthorizedPredicate allowedIndicesMatcher(String action) {
        return this.indices.allowedIndicesMatcher(action);
    }

    @Override
    public Automaton allowedActionsMatcher(String index) {
        return this.indices.allowedActionsMatcher(index);
    }

    @Override
    public boolean checkRunAs(String runAsName) {
        return this.runAs.check(runAsName);
    }

    @Override
    public boolean checkIndicesAction(String action) {
        return this.indices.check(action);
    }

    @Override
    public boolean checkIndicesPrivileges(Set<String> checkForIndexPatterns, boolean allowRestrictedIndices, Set<String> checkForPrivileges, @Nullable ResourcePrivilegesMap.Builder resourcePrivilegesMapBuilder) {
        return this.indices.checkResourcePrivileges(checkForIndexPatterns, allowRestrictedIndices, checkForPrivileges, resourcePrivilegesMapBuilder);
    }

    @Override
    public boolean checkClusterAction(String action, TransportRequest request, Authentication authentication) {
        return this.cluster.check(action, request, authentication);
    }

    @Override
    public boolean grants(ClusterPrivilege clusterPrivilege) {
        return this.cluster.implies(clusterPrivilege.buildPermission(ClusterPermission.builder()).build());
    }

    @Override
    public boolean checkApplicationResourcePrivileges(String applicationName, Set<String> checkForResources, Set<String> checkForPrivilegeNames, Collection<ApplicationPrivilegeDescriptor> storedPrivileges, @Nullable ResourcePrivilegesMap.Builder resourcePrivilegesMapBuilder) {
        return this.application.checkResourcePrivileges(applicationName, checkForResources, checkForPrivilegeNames, storedPrivileges, resourcePrivilegesMapBuilder);
    }

    @Override
    public IndicesAccessControl authorize(String action, Set<String> requestedIndicesOrAliases, Map<String, IndexAbstraction> aliasAndIndexLookup, FieldPermissionsCache fieldPermissionsCache) {
        return this.indices.authorize(action, requestedIndicesOrAliases, aliasAndIndexLookup, fieldPermissionsCache);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleRole that = (SimpleRole)o;
        return Arrays.equals(this.names, that.names) && this.cluster.equals(that.cluster) && this.indices.equals(that.indices) && this.application.equals(that.application) && this.runAs.equals(that.runAs);
    }

    public int hashCode() {
        int result = Objects.hash(this.cluster, this.indices, this.application, this.runAs);
        result = 31 * result + Arrays.hashCode(this.names);
        return result;
    }

    public void cacheHasPrivileges(Settings settings, AuthorizationEngine.PrivilegesToCheck privilegesToCheck, AuthorizationEngine.PrivilegesCheckResult privilegesCheckResult) throws ExecutionException {
        Cache<AuthorizationEngine.PrivilegesToCheck, AuthorizationEngine.PrivilegesCheckResult> cache = this.hasPrivilegesCacheReference.get();
        if (cache == null) {
            CacheBuilder cacheBuilder = CacheBuilder.builder();
            int cacheSize = (Integer)CACHE_SIZE_SETTING.get(settings);
            if (cacheSize >= 0) {
                cacheBuilder.setMaximumWeight((long)cacheSize);
            }
            this.hasPrivilegesCacheReference.compareAndSet(null, (Cache<AuthorizationEngine.PrivilegesToCheck, AuthorizationEngine.PrivilegesCheckResult>)cacheBuilder.build());
            cache = this.hasPrivilegesCacheReference.get();
        }
        cache.computeIfAbsent((Object)privilegesToCheck, ignore -> privilegesCheckResult);
    }

    public AuthorizationEngine.PrivilegesCheckResult checkPrivilegesWithCache(AuthorizationEngine.PrivilegesToCheck privilegesToCheck) {
        Cache<AuthorizationEngine.PrivilegesToCheck, AuthorizationEngine.PrivilegesCheckResult> cache = this.hasPrivilegesCacheReference.get();
        if (cache == null) {
            return null;
        }
        return (AuthorizationEngine.PrivilegesCheckResult)cache.get((Object)privilegesToCheck);
    }

    Cache<AuthorizationEngine.PrivilegesToCheck, AuthorizationEngine.PrivilegesCheckResult> getHasPrivilegesCache() {
        return this.hasPrivilegesCacheReference.get();
    }
}

