/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.user;

import java.util.Map;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.support.MetadataUtils;
import org.elasticsearch.xpack.core.security.user.User;

public class SecurityProfileUser
extends User {
    public static final String NAME = "_security_profile";
    public static final SecurityProfileUser INSTANCE = new SecurityProfileUser();
    public static final RoleDescriptor ROLE_DESCRIPTOR = new RoleDescriptor("_security_profile", null, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".security-profile", "/\\.security-profile-[0-9].*/").privileges("all").allowRestrictedIndices(true).build()}, null, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, Map.of());

    private SecurityProfileUser() {
        super(NAME, Strings.EMPTY_ARRAY);
        assert (this.enabled());
        assert (this.roles() != null && this.roles().length == 0);
    }

    @Override
    public boolean equals(Object o) {
        return INSTANCE == o;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    public static boolean is(User user) {
        return INSTANCE.equals(user);
    }
}

