/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.core.Strings;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.action.AbstractGetResourcesRequest;
import org.elasticsearch.xpack.core.action.AbstractGetResourcesResponse;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;

public class GetTransformAction
extends ActionType<Response> {
    public static final GetTransformAction INSTANCE = new GetTransformAction();
    public static final String NAME = "cluster:monitor/transform/get";
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(GetTransformAction.class);

    private GetTransformAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends AbstractGetResourcesResponse<TransformConfig>
    implements ToXContentObject {
        public static final String INVALID_TRANSFORMS_DEPRECATION_WARNING = "Found [{}] invalid transforms";
        private static final ParseField INVALID_TRANSFORMS = new ParseField("invalid_transforms", new String[0]);
        private static final ParseField ERRORS = new ParseField("errors", new String[0]);
        private final List<Error> errors;

        public Response(List<TransformConfig> transformConfigs, long count, List<Error> errors) {
            super(new QueryPage<TransformConfig>(transformConfigs, count, TransformField.TRANSFORMS));
            this.errors = errors;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.errors = in.getTransportVersion().onOrAfter(TransportVersion.V_8_1_0) ? (in.readBoolean() ? in.readList(Error::new) : null) : null;
        }

        public List<TransformConfig> getTransformConfigurations() {
            return this.getResources().results();
        }

        public long getTransformConfigurationCount() {
            return this.getResources().count();
        }

        public List<Error> getErrors() {
            return this.errors;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            ArrayList<String> invalidTransforms = new ArrayList<String>();
            builder.startObject();
            builder.field(TransformField.COUNT.getPreferredName(), this.getResources().count());
            builder.field(TransformField.TRANSFORMS.getPreferredName());
            builder.startArray();
            for (TransformConfig configResponse : this.getResources().results()) {
                configResponse.toXContent(builder, params);
                ActionRequestValidationException validationException = configResponse.validate(null);
                if (validationException == null) continue;
                invalidTransforms.add(configResponse.getId());
            }
            builder.endArray();
            if (!invalidTransforms.isEmpty()) {
                builder.startObject(INVALID_TRANSFORMS.getPreferredName());
                builder.field(TransformField.COUNT.getPreferredName(), invalidTransforms.size());
                builder.field(TransformField.TRANSFORMS.getPreferredName(), invalidTransforms);
                builder.endObject();
                deprecationLogger.warn(DeprecationCategory.OTHER, "invalid_transforms", INVALID_TRANSFORMS_DEPRECATION_WARNING, new Object[]{invalidTransforms.size()});
            }
            if (this.errors != null) {
                builder.field(ERRORS.getPreferredName(), this.errors);
            }
            builder.endObject();
            return builder;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (out.getTransportVersion().onOrAfter(TransportVersion.V_8_1_0)) {
                if (this.errors != null) {
                    out.writeBoolean(true);
                    out.writeList(this.errors);
                } else {
                    out.writeBoolean(false);
                }
            }
        }

        @Override
        protected Writeable.Reader<TransformConfig> getReader() {
            return TransformConfig::new;
        }

        public static class Error
        implements Writeable,
        ToXContentObject {
            private static final ParseField TYPE = new ParseField("type", new String[0]);
            private static final ParseField REASON = new ParseField("reason", new String[0]);
            private final String type;
            private final String reason;

            public Error(String type, String reason) {
                this.type = Objects.requireNonNull(type);
                this.reason = Objects.requireNonNull(reason);
            }

            public Error(StreamInput in) throws IOException {
                this.type = in.readString();
                this.reason = in.readString();
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                builder.field(TYPE.getPreferredName(), this.type);
                builder.field(REASON.getPreferredName(), this.reason);
                builder.endObject();
                return builder;
            }

            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.type);
                out.writeString(this.reason);
            }
        }
    }

    public static class Request
    extends AbstractGetResourcesRequest {
        private static final int MAX_SIZE_RETURN = 1000;

        public Request(String id) {
            super(id, PageParams.defaultParams(), true);
        }

        public Request() {
            super(null, PageParams.defaultParams(), true);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
        }

        public String getId() {
            return this.getResourceId();
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException exception = null;
            if (this.getPageParams() != null && this.getPageParams().getSize() > 1000) {
                exception = ValidateActions.addValidationError((String)("Param [" + PageParams.SIZE.getPreferredName() + "] has a max acceptable value of [1000]"), exception);
            }
            return exception;
        }

        @Override
        public String getCancelableTaskDescription() {
            return Strings.format((String)"get_transforms[%s]", (Object[])new Object[]{this.getResourceId()});
        }

        @Override
        public String getResourceIdField() {
            return TransformField.ID.getPreferredName();
        }
    }
}

