/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.sonar.api.SonarRuntime;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.plugins.python.IPynbProfile;
import org.sonar.python.checks.CheckList;
import org.sonarsource.analyzer.commons.RuleMetadataLoader;

public class IPynbRuleRepository
implements RulesDefinition {
    private static final String REPOSITORY_NAME = "SonarAnalyzer";
    static final String RESOURCE_FOLDER = "org/sonar/l10n/py/rules/python";
    private static final Set<String> TEMPLATE_RULE_KEYS = Collections.singleton("CommentRegularExpression");
    private final SonarRuntime runtime;

    public IPynbRuleRepository(SonarRuntime runtime) {
        this.runtime = runtime;
    }

    public void define(RulesDefinition.Context context) {
        RulesDefinition.NewRepository repository = context.createRepository("ipython", "ipynb").setName(REPOSITORY_NAME);
        RuleMetadataLoader loader = new RuleMetadataLoader(RESOURCE_FOLDER, "org/sonar/l10n/py/rules/python/Sonar_way_profile.json", this.runtime);
        loader.addRulesByAnnotatedClass(repository, IPynbRuleRepository.getCheckClasses());
        repository.rules().stream().filter(rule -> TEMPLATE_RULE_KEYS.contains(rule.key())).forEach(rule -> rule.setTemplate(true));
        repository.rules().stream().filter(rule -> IPynbProfile.DISABLED_RULES.contains(rule.key())).forEach(rule -> rule.setActivatedByDefault(false));
        repository.done();
    }

    private static List<Class<?>> getCheckClasses() {
        return StreamSupport.stream(CheckList.getChecks().spliterator(), false).map(check -> check).collect(Collectors.toList());
    }
}

