/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.plugins.python.PythonChecks;
import org.sonar.plugins.python.PythonScanner;
import org.sonar.plugins.python.api.ProjectPythonVersion;
import org.sonar.plugins.python.api.PythonVersionUtils;
import org.sonar.plugins.python.indexer.PythonIndexer;
import org.sonar.python.checks.CheckList;
import org.sonar.python.parser.PythonParser;

public final class IPynbSensor
implements Sensor {
    private final PythonChecks checks;
    private final FileLinesContextFactory fileLinesContextFactory;
    private final NoSonarFilter noSonarFilter;
    private final PythonIndexer indexer;

    public IPynbSensor(FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter, PythonIndexer indexer) {
        this.checks = new PythonChecks(checkFactory).addChecks("ipython", CheckList.getChecks());
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.noSonarFilter = noSonarFilter;
        this.indexer = indexer;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("ipynb").name("IPython Notebooks Sensor");
    }

    public void execute(SensorContext context) {
        List<InputFile> pythonFiles = IPynbSensor.getInputFiles(context);
        context.config().get("sonar.python.version").map(PythonVersionUtils::fromString).ifPresent(ProjectPythonVersion::setCurrentVersions);
        PythonScanner scanner = new PythonScanner(context, this.checks, this.fileLinesContextFactory, this.noSonarFilter, PythonParser.createIPythonParser(), this.indexer);
        scanner.execute(pythonFiles, context);
    }

    private static List<InputFile> getInputFiles(SensorContext context) {
        FilePredicates p = context.fileSystem().predicates();
        Iterable it = context.fileSystem().inputFiles(p.and(new FilePredicate[]{p.hasLanguage("ipynb")}));
        ArrayList list = new ArrayList();
        it.forEach(list::add);
        return Collections.unmodifiableList(list);
    }
}

