/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python;

import com.sonar.sslr.api.AstNode;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.PythonVisitorContext;
import org.sonar.plugins.python.api.caching.CacheContext;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.python.caching.CacheContextImpl;
import org.sonar.python.parser.PythonParser;
import org.sonar.python.semantic.ProjectLevelSymbolTable;
import org.sonar.python.semantic.SymbolUtils;
import org.sonar.python.tree.IPythonTreeMaker;
import org.sonar.python.tree.PythonTreeMaker;

public class TestPythonVisitorRunner {
    private TestPythonVisitorRunner() {
    }

    public static PythonVisitorContext scanFile(File file, PythonCheck ... visitors) {
        PythonVisitorContext context = TestPythonVisitorRunner.createContext(file);
        for (PythonCheck visitor : visitors) {
            visitor.scanFile(context);
        }
        return context;
    }

    public static PythonVisitorContext createContext(File file) {
        return TestPythonVisitorRunner.createContext(file, null);
    }

    public static PythonVisitorContext createContext(File file, @Nullable File workingDirectory) {
        return TestPythonVisitorRunner.createContext(file, workingDirectory, "", ProjectLevelSymbolTable.empty(), CacheContextImpl.dummyCache());
    }

    public static PythonVisitorContext createContext(File file, @Nullable File workingDirectory, String packageName, ProjectLevelSymbolTable projectLevelSymbolTable, CacheContext cacheContext) {
        TestPythonFile pythonFile = new TestPythonFile(file);
        FileInput rootTree = TestPythonVisitorRunner.parseFile(pythonFile);
        return new PythonVisitorContext(rootTree, pythonFile, workingDirectory, packageName, projectLevelSymbolTable, cacheContext);
    }

    public static ProjectLevelSymbolTable globalSymbols(List<File> files, File baseDir) {
        ProjectLevelSymbolTable projectLevelSymbolTable = new ProjectLevelSymbolTable();
        for (File file : files) {
            TestPythonFile pythonFile = new TestPythonFile(file);
            if (pythonFile.isIPython()) continue;
            FileInput astRoot = TestPythonVisitorRunner.parseFile(pythonFile);
            String packageName = SymbolUtils.pythonPackageName(file, baseDir.getAbsolutePath());
            projectLevelSymbolTable.addModule(astRoot, packageName, pythonFile);
        }
        return projectLevelSymbolTable;
    }

    private static FileInput parseFile(TestPythonFile file) {
        PythonParser parser = file.isIPython() ? PythonParser.createIPythonParser() : PythonParser.create();
        PythonTreeMaker treeMaker = file.isIPython() ? new IPythonTreeMaker() : new PythonTreeMaker();
        AstNode astNode = parser.parse(file.content());
        return treeMaker.fileInput(astNode);
    }

    private static class TestPythonFile
    implements PythonFile {
        private final File file;

        public TestPythonFile(File file) {
            this.file = file;
        }

        @Override
        public String content() {
            try {
                return new String(Files.readAllBytes(this.file.toPath()), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot read " + this.file, e);
            }
        }

        @Override
        public String fileName() {
            return this.file.getName();
        }

        @Override
        public URI uri() {
            return this.file.toURI();
        }

        @Override
        public String key() {
            return this.file.getPath();
        }

        public boolean isIPython() {
            return this.fileName().endsWith(".ipynb");
        }
    }
}

