/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.cfg;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.plugins.python.api.cfg.CfgBlock;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;

public abstract class PythonCfgBlock
implements CfgBlock {
    private final LinkedList<Tree> elements = new LinkedList();
    private final Set<CfgBlock> predecessors = new LinkedHashSet<CfgBlock>();

    @Override
    public Set<CfgBlock> predecessors() {
        return this.predecessors;
    }

    @Override
    public List<Tree> elements() {
        return this.elements;
    }

    public void addElement(Tree tree) {
        this.elements.addFirst(tree);
    }

    public boolean isEmptyBlock() {
        return this.elements.isEmpty() && this.successors().size() == 1;
    }

    PythonCfgBlock firstNonEmptySuccessor() {
        PythonCfgBlock block = this;
        HashSet<PythonCfgBlock> skippedBlocks = new HashSet<PythonCfgBlock>();
        while (block.isEmptyBlock()) {
            PythonCfgBlock next = (PythonCfgBlock)block.successors().iterator().next();
            if (skippedBlocks.add(next)) {
                block = next;
                continue;
            }
            return block;
        }
        return block;
    }

    abstract void replaceSuccessors(Map<PythonCfgBlock, PythonCfgBlock> var1);

    public String toString() {
        return this.toStringDisplayPosition() + this.elements.stream().map(elem -> elem.getKind().toString()).collect(Collectors.joining(";"));
    }

    protected String toStringDisplayPosition() {
        if (this.elements.isEmpty()) {
            return "empty";
        }
        Token token = this.elements.get(0).firstToken();
        return token.line() + ":" + token.column() + ":";
    }

    void addPredecessor(PythonCfgBlock block) {
        this.predecessors.add(block);
    }
}

