/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.ExceptClause;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Tuple;
import org.sonar.python.checks.Expressions;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S5713")
public class ChildAndParentExceptionCaughtCheck
extends PythonSubscriptionCheck {
    public static final String QUICK_FIX_MESSAGE = "Remove the redundant Exception";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.EXCEPT_CLAUSE, ChildAndParentExceptionCaughtCheck::checkExceptClause);
        context.registerSyntaxNodeConsumer(Tree.Kind.EXCEPT_GROUP_CLAUSE, ChildAndParentExceptionCaughtCheck::checkExceptClause);
    }

    private static void checkExceptClause(SubscriptionContext ctx) {
        ExceptClause exceptClause = (ExceptClause)ctx.syntaxNode();
        HashMap<ClassSymbol, List<Expression>> caughtExceptionsBySymbol = new HashMap<ClassSymbol, List<Expression>>();
        Expression exceptionExpression = exceptClause.exception();
        if (exceptionExpression == null) {
            return;
        }
        TreeUtils.flattenTuples(exceptionExpression).forEach(e -> ChildAndParentExceptionCaughtCheck.addExceptionExpression(e, caughtExceptionsBySymbol));
        ChildAndParentExceptionCaughtCheck.checkCaughtExceptions(ctx, caughtExceptionsBySymbol);
    }

    private static void checkCaughtExceptions(SubscriptionContext ctx, Map<ClassSymbol, List<Expression>> caughtExceptionsBySymbol) {
        caughtExceptionsBySymbol.forEach((currentSymbol, caughtExceptionsWithSameSymbol) -> {
            List caughtParentExceptions;
            Expression currentException = (Expression)caughtExceptionsWithSameSymbol.get(0);
            if (caughtExceptionsWithSameSymbol.size() > 1) {
                PythonCheck.PreciseIssue issue = ctx.addIssue(currentException, "Remove this duplicate Exception class.");
                ChildAndParentExceptionCaughtCheck.addQuickFix(issue, currentException);
                caughtExceptionsWithSameSymbol.stream().skip(1L).forEach(e -> issue.secondary((Tree)e, "Duplicate."));
            }
            if (!(caughtParentExceptions = caughtExceptionsBySymbol.entrySet().stream().filter(entry -> entry.getKey() != currentSymbol && currentSymbol.isOrExtends((ClassSymbol)entry.getKey())).collect(Collectors.toList())).isEmpty()) {
                PythonCheck.PreciseIssue issue = ctx.addIssue(currentException, "Remove this redundant Exception class; it derives from another which is already caught.");
                ChildAndParentExceptionCaughtCheck.addQuickFix(issue, currentException);
                caughtParentExceptions.stream().map(Map.Entry::getValue).forEach(entries -> ChildAndParentExceptionCaughtCheck.addSecondaryLocations(issue, entries));
            }
        });
    }

    private static void addQuickFix(PythonCheck.PreciseIssue issue, Expression currentException) {
        PythonQuickFix quickFix = ChildAndParentExceptionCaughtCheck.createQuickFix(currentException);
        if (quickFix != null) {
            issue.addQuickFix(quickFix);
        }
    }

    private static List<String> collectNamesFromTuple(Expression expression) {
        expression = Expressions.removeParentheses(expression);
        if (expression.is(Tree.Kind.TUPLE)) {
            Tuple tuple = (Tuple)expression;
            return tuple.elements().stream().map(ChildAndParentExceptionCaughtCheck::collectNames).flatMap(Collection::stream).collect(Collectors.toList());
        }
        throw new IllegalArgumentException("Unsupported kind of tree element: " + expression.getKind().name());
    }

    private static List<String> collectNames(Expression expression) {
        expression = Expressions.removeParentheses(expression);
        if (expression.is(Tree.Kind.NAME)) {
            Name name = (Name)expression;
            return List.of(name.name());
        }
        if (expression.is(Tree.Kind.QUALIFIED_EXPR)) {
            String name = TreeUtils.tokens(expression).stream().map(Token::value).collect(Collectors.joining());
            return List.of(name);
        }
        throw new IllegalArgumentException("Unsupported kind of tree element: " + expression.getKind().name());
    }

    private static PythonQuickFix createQuickFix(Expression currentException) {
        try {
            String currentExceptionName = ChildAndParentExceptionCaughtCheck.collectNames(currentException).get(0);
            return Optional.of(currentException).map(exception -> TreeUtils.firstAncestorOfKind(exception, Tree.Kind.EXCEPT_CLAUSE)).map(ExceptClause.class::cast).map(ExceptClause::exception).map(exceptions -> {
                List<String> names = ChildAndParentExceptionCaughtCheck.collectNamesFromTuple(exceptions);
                names.remove(currentExceptionName);
                String text = names.size() == 1 ? names.get(0) : names.stream().collect(Collectors.joining(", ", "(", ")"));
                return PythonQuickFix.newQuickFix(QUICK_FIX_MESSAGE).addTextEdit(TextEditUtils.replace(exceptions, text)).build();
            }).orElse(null);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static void addExceptionExpression(Expression exceptionExpression, Map<ClassSymbol, List<Expression>> caughtExceptionsByFQN) {
        Symbol symbol;
        if (exceptionExpression instanceof HasSymbol && (symbol = ((HasSymbol)((Object)exceptionExpression)).symbol()) != null && symbol.kind().equals((Object)Symbol.Kind.CLASS)) {
            ClassSymbol classSymbol = (ClassSymbol)symbol;
            caughtExceptionsByFQN.computeIfAbsent(classSymbol, k -> new ArrayList()).add(exceptionExpression);
        }
    }

    private static void addSecondaryLocations(PythonCheck.PreciseIssue issue, List<Expression> others) {
        for (Expression other : others) {
            issue.secondary(other, "Parent class.");
        }
    }
}

