/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S6660")
public class DirectTypeComparisonCheck
extends PythonSubscriptionCheck {
    private static final Set<String> OPERATORS = Set.of("==", "!=");

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.COMPARISON, ctx -> {
            BinaryExpression binaryExpression = (BinaryExpression)ctx.syntaxNode();
            if (!OPERATORS.contains(binaryExpression.operator().value())) {
                return;
            }
            DirectTypeComparisonCheck.checkBinaryExpression(ctx, binaryExpression);
        });
    }

    private static void checkBinaryExpression(SubscriptionContext ctx, BinaryExpression binaryExpression) {
        if (DirectTypeComparisonCheck.isDirectTypeComparison(binaryExpression.leftOperand(), binaryExpression.rightOperand())) {
            Token operator;
            ctx.addIssue(operator, "==".equals((operator = binaryExpression.operator()).value()) ? "Use the `isinstance()` function here." : "Use `not isinstance()` here.");
        }
    }

    private static boolean isDirectTypeComparison(Expression lhs, Expression rhs) {
        return DirectTypeComparisonCheck.isTypeBuiltinCall(lhs) && TreeUtils.getSymbolFromTree(rhs).filter(s -> s.is(Symbol.Kind.CLASS)).isPresent() || DirectTypeComparisonCheck.isTypeBuiltinCall(rhs) && TreeUtils.getSymbolFromTree(lhs).filter(s -> s.is(Symbol.Kind.CLASS)).isPresent();
    }

    private static boolean isTypeBuiltinCall(Expression expression) {
        if (!expression.is(Tree.Kind.CALL_EXPR)) {
            return false;
        }
        Symbol calleeSymbol = ((CallExpression)expression).calleeSymbol();
        return calleeSymbol != null && "type".equals(calleeSymbol.fullyQualifiedName());
    }
}

