/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.AnnotatedAssignment;
import org.sonar.plugins.python.api.tree.AssignmentExpression;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S6560")
public class DjangoNonDictSerializationCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Use a dictionary object here, or set the \"safe\" flag to False.";
    private static final String JSON_RESPONSE_FUNCTION_NAME = "django.http.JsonResponse";
    private static final int MAX_RECURSION = 5;

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            CallExpression callExpression = (CallExpression)ctx.syntaxNode();
            Symbol symbol = callExpression.calleeSymbol();
            if (symbol != null && JSON_RESPONSE_FUNCTION_NAME.equals(symbol.fullyQualifiedName())) {
                DjangoNonDictSerializationCheck.checkForDictSerialization(ctx, callExpression);
            }
        });
    }

    private static void checkForDictSerialization(SubscriptionContext ctx, CallExpression callExpression) {
        RegularArgument dataArg;
        RegularArgument safe = TreeUtils.nthArgumentOrKeyword(2, "safe", callExpression.arguments());
        if ((safe == null || safe.expression().is(Tree.Kind.NAME) && "True".equals(((Name)safe.expression()).name())) && (dataArg = TreeUtils.nthArgumentOrKeyword(0, "data", callExpression.arguments())) != null && !DjangoNonDictSerializationCheck.couldExpressionBeADict(dataArg.expression())) {
            ctx.addIssue(dataArg, MESSAGE);
        }
    }

    private static boolean couldExpressionBeADict(Expression expression) {
        if (expression.is(Tree.Kind.NAME)) {
            return DjangoNonDictSerializationCheck.couldDictBeAssignedToDataArg((Name)expression, 0);
        }
        return DjangoNonDictSerializationCheck.couldTypeBeADict(expression);
    }

    private static boolean couldDictBeAssignedToDataArg(Name dataArg, int recursiveCount) {
        Tree assignment;
        Expression assignedValue;
        List assignmentStmts;
        Symbol dataArgSymbol = dataArg.symbol();
        if (recursiveCount <= 5 && dataArgSymbol != null && (assignmentStmts = dataArgSymbol.usages().stream().filter(usage -> usage.kind() == Usage.Kind.ASSIGNMENT_LHS).map(Usage::tree).map(usage -> TreeUtils.firstAncestorOfKind(usage, Tree.Kind.ASSIGNMENT_STMT, Tree.Kind.ANNOTATED_ASSIGNMENT, Tree.Kind.ASSIGNMENT_EXPRESSION)).filter(Objects::nonNull).collect(Collectors.toList())).size() == 1 && (assignedValue = DjangoNonDictSerializationCheck.getAssignedValue(assignment = (Tree)assignmentStmts.get(0))) != null) {
            if (assignedValue.is(Tree.Kind.NAME)) {
                return DjangoNonDictSerializationCheck.couldDictBeAssignedToDataArg((Name)assignedValue, recursiveCount + 1);
            }
            return DjangoNonDictSerializationCheck.couldTypeBeADict(assignedValue);
        }
        return true;
    }

    private static boolean couldTypeBeADict(Expression expression) {
        return expression.is(Tree.Kind.DICTIONARY_LITERAL) || expression.is(Tree.Kind.DICT_COMPREHENSION) || expression.type().canBeOrExtend("dict");
    }

    @CheckForNull
    private static Expression getAssignedValue(Tree assignment) {
        if (assignment.is(Tree.Kind.ASSIGNMENT_STMT)) {
            return ((AssignmentStatement)assignment).assignedValue();
        }
        if (assignment.is(Tree.Kind.ANNOTATED_ASSIGNMENT)) {
            return ((AnnotatedAssignment)assignment).assignedValue();
        }
        return ((AssignmentExpression)assignment).expression();
    }
}

