/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.AnnotatedAssignment;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.LambdaExpression;
import org.sonar.plugins.python.api.tree.Tree;

@Rule(key="S6661")
public class LambdaAssignmentCheck
extends PythonSubscriptionCheck {
    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.ASSIGNMENT_STMT, ctx -> LambdaAssignmentCheck.checkAssignmentStatement(ctx, (AssignmentStatement)ctx.syntaxNode()));
        context.registerSyntaxNodeConsumer(Tree.Kind.ANNOTATED_ASSIGNMENT, ctx -> LambdaAssignmentCheck.checkAnnotatedAssignment(ctx, (AnnotatedAssignment)ctx.syntaxNode()));
    }

    private static void checkAssignmentStatement(SubscriptionContext ctx, AssignmentStatement stmt) {
        Expression right = stmt.assignedValue();
        LambdaAssignmentCheck.addIssueIfLambda(ctx, right);
    }

    private static void checkAnnotatedAssignment(SubscriptionContext ctx, AnnotatedAssignment assignment) {
        Expression right = assignment.assignedValue();
        if (right != null) {
            LambdaAssignmentCheck.addIssueIfLambda(ctx, right);
        }
    }

    private static void addIssueIfLambda(SubscriptionContext ctx, Expression assignedExpression) {
        if (assignedExpression.is(Tree.Kind.LAMBDA)) {
            LambdaExpression lambdaExpression = (LambdaExpression)assignedExpression;
            ctx.addIssue(lambdaExpression.lambdaKeyword(), "Define function instead of this lambda assignment statement.");
        }
    }
}

