/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.AnnotatedAssignment;
import org.sonar.plugins.python.api.tree.ComprehensionExpression;
import org.sonar.plugins.python.api.tree.DictCompExpression;
import org.sonar.plugins.python.api.tree.ExceptClause;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionList;
import org.sonar.plugins.python.api.tree.ForStatement;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.CheckUtils;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S1481")
public class UnusedLocalVariableCheck
extends PythonSubscriptionCheck {
    private static final String DEFAULT = "(_[a-zA-Z0-9_]*|dummy|unused|ignored)";
    private static final String MESSAGE = "Remove the unused local variable \"%s\".";
    private static final String SEQUENCE_UNPACKING_MESSAGE = "Replace unused local variable \"%s\" with \"_\".";
    private static final String SEQUENCE_UNPACKING_QUICK_FIX_MESSAGE = "Replace with \"_\"";
    private static final String EXCEPT_CLAUSE_QUICK_FIX_MESSAGE = "Remove the unused local variable";
    private static final String SECONDARY_MESSAGE = "Assignment to unused local variable \"%s\".";
    @RuleProperty(key="regex", description="Regular expression used to identify variable name to ignore.", defaultValue="(_[a-zA-Z0-9_]*|dummy|unused|ignored)")
    public String format = "(_[a-zA-Z0-9_]*|dummy|unused|ignored)";
    private Pattern pattern;

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        this.pattern = Pattern.compile(this.format);
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> this.checkLocalVars((SubscriptionContext)ctx, ctx.syntaxNode(), ((FunctionDef)ctx.syntaxNode()).localVariables()));
        context.registerSyntaxNodeConsumer(Tree.Kind.DICT_COMPREHENSION, ctx -> this.checkLocalVars((SubscriptionContext)ctx, ctx.syntaxNode(), ((DictCompExpression)ctx.syntaxNode()).localVariables()));
        context.registerSyntaxNodeConsumer(Tree.Kind.LIST_COMPREHENSION, ctx -> this.checkLocalVars((SubscriptionContext)ctx, ctx.syntaxNode(), ((ComprehensionExpression)ctx.syntaxNode()).localVariables()));
        context.registerSyntaxNodeConsumer(Tree.Kind.SET_COMPREHENSION, ctx -> this.checkLocalVars((SubscriptionContext)ctx, ctx.syntaxNode(), ((ComprehensionExpression)ctx.syntaxNode()).localVariables()));
        context.registerSyntaxNodeConsumer(Tree.Kind.GENERATOR_EXPR, ctx -> this.checkLocalVars((SubscriptionContext)ctx, ctx.syntaxNode(), ((ComprehensionExpression)ctx.syntaxNode()).localVariables()));
    }

    private void checkLocalVars(SubscriptionContext ctx, Tree functionTree, Set<Symbol> symbols) {
        if (CheckUtils.containsCallToLocalsFunction(functionTree)) {
            return;
        }
        symbols.stream().filter(s -> !this.pattern.matcher(s.name()).matches()).filter(UnusedLocalVariableCheck::hasOnlyBindingUsages).forEach(symbol -> {
            List usages = symbol.usages().stream().filter(usage -> usage.tree().parent() == null || !usage.tree().parent().is(Tree.Kind.PARAMETER)).filter(usage -> !UnusedLocalVariableCheck.isTupleDeclaration(usage)).filter(usage -> usage.kind() != Usage.Kind.FUNC_DECLARATION).filter(usage -> usage.kind() != Usage.Kind.CLASS_DECLARATION).collect(Collectors.toList());
            if (!usages.isEmpty()) {
                Usage firstUsage = (Usage)usages.get(0);
                PythonCheck.PreciseIssue issue = this.createIssue(ctx, (Symbol)symbol, firstUsage);
                usages.stream().skip(1L).forEach(usage -> issue.secondary(usage.tree(), String.format(SECONDARY_MESSAGE, symbol.name())));
            }
        });
    }

    public PythonCheck.PreciseIssue createIssue(SubscriptionContext ctx, Symbol symbol, Usage usage) {
        if (UnusedLocalVariableCheck.isSequenceUnpacking(usage)) {
            PythonQuickFix quickFix = PythonQuickFix.newQuickFix(SEQUENCE_UNPACKING_QUICK_FIX_MESSAGE, TextEditUtils.replace(usage.tree(), "_"));
            PythonCheck.PreciseIssue issue = ctx.addIssue(usage.tree(), String.format(SEQUENCE_UNPACKING_MESSAGE, symbol.name()));
            issue.addQuickFix(quickFix);
            return issue;
        }
        PythonCheck.PreciseIssue issue = ctx.addIssue(usage.tree(), String.format(MESSAGE, symbol.name()));
        UnusedLocalVariableCheck.createExceptClauseQuickFix(usage, issue);
        return issue;
    }

    private static void createExceptClauseQuickFix(Usage usage, PythonCheck.PreciseIssue issue) {
        Optional.of(usage).filter(u -> u.kind() == Usage.Kind.EXCEPTION_INSTANCE).map(Usage::tree).map(Tree::parent).filter(ExceptClause.class::isInstance).map(ExceptClause.class::cast).filter(ec -> Objects.nonNull(ec.exception())).map(ec -> {
            String replacement = TreeUtils.treeToString(ec.exception(), false) + ":";
            Expression from = ec.exception();
            Token to = ec.colon();
            PythonTextEdit textEdit = TextEditUtils.replaceRange(from, to, replacement);
            return PythonQuickFix.newQuickFix(EXCEPT_CLAUSE_QUICK_FIX_MESSAGE, textEdit);
        }).ifPresent(issue::addQuickFix);
    }

    private static boolean hasOnlyBindingUsages(Symbol symbol) {
        List<Usage> usages = symbol.usages();
        if (UnusedLocalVariableCheck.isOnlyTypeAnnotation(usages)) {
            return false;
        }
        return usages.stream().noneMatch(usage -> usage.kind() == Usage.Kind.IMPORT) && usages.stream().allMatch(Usage::isBindingUsage);
    }

    private static boolean isOnlyTypeAnnotation(List<Usage> usages) {
        return usages.size() == 1 && usages.get(0).isBindingUsage() && TreeUtils.firstAncestor(usages.get(0).tree(), t -> t.is(Tree.Kind.ANNOTATED_ASSIGNMENT) && ((AnnotatedAssignment)t).assignedValue() == null) != null;
    }

    private static boolean isTupleDeclaration(Usage usage) {
        Tree tree = usage.tree();
        return !UnusedLocalVariableCheck.isSequenceUnpacking(usage) && TreeUtils.firstAncestor(tree, t -> t.is(Tree.Kind.TUPLE) || t.is(Tree.Kind.EXPRESSION_LIST) && ((ExpressionList)t).expressions().size() > 1 || t.is(Tree.Kind.FOR_STMT) && ((ForStatement)t).expressions().size() > 1 && ((ForStatement)t).expressions().contains(tree)) != null;
    }

    private static boolean isSequenceUnpacking(Usage usage) {
        return Optional.of(usage).filter(u -> u.kind() == Usage.Kind.ASSIGNMENT_LHS).map(Usage::tree).map(tree -> TreeUtils.firstAncestorOfKind(tree, Tree.Kind.EXPRESSION_LIST)).map(ExpressionList.class::cast).filter(list -> list.expressions().size() > 1).isPresent();
    }
}

