/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TypeAnnotation;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S6542")
public class UseOfAnyAsTypeHintCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Use a more specific type than `Any` for this type hint.";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.RETURN_TYPE_ANNOTATION, UseOfAnyAsTypeHintCheck::checkForAnyInTypeHint);
        context.registerSyntaxNodeConsumer(Tree.Kind.PARAMETER_TYPE_ANNOTATION, UseOfAnyAsTypeHintCheck::checkForAnyInTypeHint);
        context.registerSyntaxNodeConsumer(Tree.Kind.VARIABLE_TYPE_ANNOTATION, UseOfAnyAsTypeHintCheck::checkForAnyInTypeHint);
    }

    private static void checkForAnyInTypeHint(SubscriptionContext ctx) {
        TypeAnnotation typeAnnotation = (TypeAnnotation)ctx.syntaxNode();
        if (UseOfAnyAsTypeHintCheck.isTypeAny(typeAnnotation)) {
            ctx.addIssue(typeAnnotation.expression(), MESSAGE);
        }
    }

    private static boolean isTypeAny(@Nullable TypeAnnotation typeAnnotation) {
        return Optional.ofNullable(typeAnnotation).map(annotation -> "typing.Any".equals(TreeUtils.fullyQualifiedNameFromExpression(annotation.expression()))).orElse(false);
    }
}

