/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.DictionaryLiteral;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.NumericLiteral;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.python.checks.cdk.AbstractCdkResourceCheck;
import org.sonar.python.checks.cdk.CdkPredicate;
import org.sonar.python.checks.cdk.CdkUtils;

public class UnrestrictedAdministrationCheckPartCfnSecurity
extends AbstractCdkResourceCheck {
    private static final String MESSAGE = "Change this IP range to a subset of trusted IP addresses.";
    private static final String IP_PROTOCOL = "ip_protocol";
    private static final String CIDR_IP = "cidr_ip";
    private static final String CIDR_IPV6 = "cidr_ipv6";
    private static final String IPPROTOCOL = "ipProtocol";
    private static final String CIDRIP = "cidrIp";
    private static final String CIDRIPV6 = "cidrIpv6";
    private static final Set<String> SENSITIVE_PROTOCOL = Set.of("tcp", "6");
    private static final String ANY_PROTOCOL = "-1";
    private static final String EMPTY_IPV4 = "0.0.0.0/0";
    private static final String EMPTY_IPV6 = "::/0";
    private static final long[] ADMIN_PORTS = new long[]{22L, 3389L};

    @Override
    protected void registerFqnConsumer() {
        this.checkFqn("aws_cdk.aws_ec2.CfnSecurityGroup", UnrestrictedAdministrationCheckPartCfnSecurity::checkCfnSecurityGroup);
        this.checkFqn("aws_cdk.aws_ec2.CfnSecurityGroupIngress", UnrestrictedAdministrationCheckPartCfnSecurity::checkCallCfnSecuritySensitive);
    }

    private static void checkCfnSecurityGroup(SubscriptionContext ctx, CallExpression callExpression) {
        CdkUtils.getArgument(ctx, callExpression, "security_group_ingress").flatMap(CdkUtils::getListExpression).map(list -> list.elements().expressions()).orElse(Collections.emptyList()).stream().map(expression -> CdkUtils.ExpressionFlow.build(ctx, expression)).forEach(flow -> {
            UnrestrictedAdministrationCheckPartCfnSecurity.raiseIssueIfIngressPropertyCallWithSensitiveArgument(ctx, flow.getLast());
            UnrestrictedAdministrationCheckPartCfnSecurity.raiseIssueIfDictionaryWithSensitiveArgument(ctx, flow.getLast());
        });
    }

    private static void raiseIssueIfIngressPropertyCallWithSensitiveArgument(SubscriptionContext ctx, Expression expression) {
        CdkUtils.getCall(expression, "aws_cdk.aws_ec2.CfnSecurityGroup.IngressProperty").ifPresent(callExpression -> UnrestrictedAdministrationCheckPartCfnSecurity.checkCallCfnSecuritySensitive(ctx, callExpression));
    }

    private static void checkCallCfnSecuritySensitive(SubscriptionContext ctx, CallExpression callExpression) {
        if (UnrestrictedAdministrationCheckPartCfnSecurity.isCallWithArgumentBadProtocolEmptyIpAddressAdminPort(ctx, callExpression) || UnrestrictedAdministrationCheckPartCfnSecurity.isCallWithArgumentInvalidProtocolEmptyIpAddress(ctx, callExpression)) {
            CdkUtils.getArgument(ctx, callExpression, CIDR_IP).ifPresent(flow -> flow.addIssue(MESSAGE, new IssueLocation[0]));
            CdkUtils.getArgument(ctx, callExpression, CIDR_IPV6).ifPresent(flow -> flow.addIssue(MESSAGE, new IssueLocation[0]));
        }
    }

    private static boolean isCallWithArgumentBadProtocolEmptyIpAddressAdminPort(SubscriptionContext ctx, CallExpression call) {
        return CdkUtils.getArgument(ctx, call, IP_PROTOCOL).filter(flow -> flow.hasExpression(CdkPredicate.isString(SENSITIVE_PROTOCOL))).isPresent() && (CdkUtils.getArgument(ctx, call, CIDR_IP).filter(flow -> flow.hasExpression(CdkPredicate.isString(EMPTY_IPV4))).isPresent() || CdkUtils.getArgument(ctx, call, CIDR_IPV6).filter(flow -> flow.hasExpression(CdkPredicate.isString(EMPTY_IPV6))).isPresent()) && UnrestrictedAdministrationCheckPartCfnSecurity.hasSensitivePortRange(call, "from_port", "to_port", ADMIN_PORTS);
    }

    private static boolean isCallWithArgumentInvalidProtocolEmptyIpAddress(SubscriptionContext ctx, CallExpression call) {
        return CdkUtils.getArgument(ctx, call, IP_PROTOCOL).filter(flow -> flow.hasExpression(CdkPredicate.isString(ANY_PROTOCOL))).isPresent() && (CdkUtils.getArgument(ctx, call, CIDR_IP).filter(flow -> flow.hasExpression(CdkPredicate.isString(EMPTY_IPV4))).isPresent() || CdkUtils.getArgument(ctx, call, CIDR_IPV6).filter(flow -> flow.hasExpression(CdkPredicate.isString(EMPTY_IPV6))).isPresent());
    }

    private static void raiseIssueIfDictionaryWithSensitiveArgument(SubscriptionContext ctx, Expression expression) {
        CdkUtils.getDictionary(expression).ifPresent(dictionary -> {
            DictionaryAsMap map = DictionaryAsMap.build(ctx, dictionary);
            if (UnrestrictedAdministrationCheckPartCfnSecurity.isDictionaryWithAttributeBadProtocolEmptyIpAddressAdminPort(map) || UnrestrictedAdministrationCheckPartCfnSecurity.isDictionaryWithAttributeInvalidProtocolEmptyIpAddress(map)) {
                map.addIssue(CIDRIP, MESSAGE);
                map.addIssue(CIDRIPV6, MESSAGE);
            }
        });
    }

    private static boolean isDictionaryWithAttributeBadProtocolEmptyIpAddressAdminPort(DictionaryAsMap map) {
        return map.hasKeyValuePair(IPPROTOCOL, CdkPredicate.isString(SENSITIVE_PROTOCOL)) && (map.hasKeyValuePair(CIDRIP, CdkPredicate.isString(EMPTY_IPV4)) || map.hasKeyValuePair(CIDRIPV6, CdkPredicate.isString(EMPTY_IPV6))) && map.hasSensitivePortRange("fromPort", "toPort");
    }

    private static boolean isDictionaryWithAttributeInvalidProtocolEmptyIpAddress(DictionaryAsMap map) {
        return map.hasKeyValuePair(IPPROTOCOL, CdkPredicate.isString(ANY_PROTOCOL)) && (map.hasKeyValuePair(CIDRIP, CdkPredicate.isString(EMPTY_IPV4)) || map.hasKeyValuePair(CIDRIPV6, CdkPredicate.isString(EMPTY_IPV6)));
    }

    private static Optional<Long> getArgumentAsLong(CallExpression callExpression, String name) {
        return CdkUtils.getArgument(null, callExpression, name).flatMap(flow -> flow.getExpression(CdkPredicate.isNumericLiteral())).map(NumericLiteral.class::cast).map(NumericLiteral::valueAsLong);
    }

    private static boolean hasSensitivePortRange(CallExpression callExpression, String minName, String maxName, long[] numbers) {
        Optional<Long> min = UnrestrictedAdministrationCheckPartCfnSecurity.getArgumentAsLong(callExpression, minName);
        Optional<Long> max = UnrestrictedAdministrationCheckPartCfnSecurity.getArgumentAsLong(callExpression, maxName);
        if (min.isEmpty() || max.isEmpty()) {
            return false;
        }
        return UnrestrictedAdministrationCheckPartCfnSecurity.isInInterval(min.get(), max.get(), numbers);
    }

    public static boolean isInInterval(long min, long max, long[] numbers) {
        for (long port : numbers) {
            if (min > port || port > max) continue;
            return true;
        }
        return false;
    }

    static class DictionaryAsMap {
        Map<String, CdkUtils.ResolvedKeyValuePair> map = new HashMap<String, CdkUtils.ResolvedKeyValuePair>();

        DictionaryAsMap() {
        }

        public static DictionaryAsMap build(SubscriptionContext ctx, DictionaryLiteral dictionary) {
            DictionaryAsMap dict = new DictionaryAsMap();
            List pairs = dictionary.elements().stream().map(e -> CdkUtils.getKeyValuePair(ctx, e)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            for (CdkUtils.ResolvedKeyValuePair pair : pairs) {
                pair.key.getExpression(CdkPredicate.isStringLiteral()).map(StringLiteral.class::cast).ifPresent(key -> dict.map.put(key.trimmedQuotesValue(), pair));
            }
            return dict;
        }

        public boolean hasKeyValuePair(String key, Predicate<Expression> valuePredicate) {
            return this.map.containsKey(key) && this.map.get((Object)key).value.hasExpression(valuePredicate);
        }

        public Optional<Expression> get(String key, Predicate<Expression> valuePredicate) {
            if (!this.map.containsKey(key)) {
                return Optional.empty();
            }
            return this.map.get((Object)key).value.getExpression(valuePredicate);
        }

        public Optional<Expression> getKeyString(String key) {
            return Optional.ofNullable(this.map.get(key)).flatMap(keyValuePair -> keyValuePair.key.getExpression(CdkPredicate.isStringLiteral()));
        }

        public Optional<CdkUtils.ExpressionFlow> getValue(String key) {
            return Optional.ofNullable(this.map.get(key)).map(keyValuePair -> keyValuePair.value);
        }

        public void addIssue(String key, String message) {
            if (this.map.containsKey(key)) {
                this.map.get((Object)key).value.addIssue(message, new IssueLocation[0]);
            }
        }

        public Optional<Long> getArgumentAsLong(String name) {
            return this.get(name, CdkPredicate.isNumericLiteral()).map(NumericLiteral.class::cast).map(NumericLiteral::valueAsLong);
        }

        boolean hasSensitivePortRange(String minName, String maxName) {
            Optional<Long> min = this.getArgumentAsLong(minName);
            Optional<Long> max = this.getArgumentAsLong(maxName);
            if (min.isEmpty() || max.isEmpty()) {
                return false;
            }
            return UnrestrictedAdministrationCheckPartCfnSecurity.isInInterval(min.get(), max.get(), ADMIN_PORTS);
        }
    }
}

