/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.parser;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.impl.Lexer;
import com.sonar.sslr.impl.Parser;
import java.util.List;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonGrammarBuilder;
import org.sonar.python.lexer.LexerState;
import org.sonar.python.lexer.PythonLexer;
import org.sonar.python.tree.StringElementImpl;
import org.sonar.python.tree.TokenImpl;

public class FStringParser {
    private final LexerState lexerState;
    private final Lexer lexer;
    private final Parser<Grammar> internalParser = Parser.builder(new PythonGrammarBuilder().create()).build();

    public FStringParser() {
        this.lexerState = new LexerState();
        this.lexer = PythonLexer.fStringLexer(this.lexerState);
        this.internalParser.setRootRule(this.internalParser.getGrammar().rule(PythonGrammar.F_STRING_CONTENT));
    }

    public List<AstNode> fStringExpressions(Token fStringToken) {
        StringElementImpl element = new StringElementImpl(new TokenImpl(fStringToken));
        String literalValue = element.trimmedQuotesValue();
        this.lexerState.reset(fStringToken.getLine(), fStringToken.getColumn() + element.contentStartIndex());
        this.lexer.lex(literalValue);
        List<Token> tokens = this.lexer.getTokens();
        AstNode astNode = this.internalParser.parse(tokens);
        return astNode.getChildren(PythonGrammar.FORMATTED_EXPR);
    }
}

