/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.parser;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.Rule;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.impl.Lexer;
import com.sonar.sslr.impl.Parser;
import com.sonar.sslr.impl.matcher.RuleDefinition;
import java.util.ArrayList;
import java.util.List;
import org.sonar.python.api.IPythonGrammarBuilder;
import org.sonar.python.api.PythonGrammarBuilder;
import org.sonar.python.api.PythonTokenType;
import org.sonar.python.lexer.LexerState;
import org.sonar.python.lexer.PythonLexer;

public final class PythonParser {
    private final Parser<Grammar> sslrParser;

    public static PythonParser create() {
        LexerState lexerState = new LexerState();
        return new PythonParser(new PythonGrammarBuilder().create(), lexerState, PythonLexer.create(lexerState));
    }

    public static PythonParser createIPythonParser() {
        LexerState lexerState = new LexerState();
        return new PythonParser(new IPythonGrammarBuilder().create(), lexerState, PythonLexer.ipynbLexer(lexerState));
    }

    private PythonParser(Grammar grammar, LexerState lexerState, Lexer lexer) {
        this.sslrParser = new SslrPythonParser(grammar, lexerState, lexer);
    }

    public AstNode parse(String source) {
        return this.sslrParser.parse(source);
    }

    public void setRootRule(Rule rule) {
        this.sslrParser.setRootRule(rule);
    }

    public Grammar getGrammar() {
        return this.sslrParser.getGrammar();
    }

    public RuleDefinition getRootRule() {
        return this.sslrParser.getRootRule();
    }

    private static class SslrPythonParser
    extends Parser<Grammar> {
        private final LexerState lexerState;
        private final Lexer lexer;

        private SslrPythonParser(Grammar grammar, LexerState lexerState, Lexer lexer) {
            super(grammar);
            super.setRootRule(((Grammar)super.getGrammar()).getRootRule());
            this.lexerState = lexerState;
            this.lexer = lexer;
        }

        @Override
        public AstNode parse(String source) {
            this.lexerState.reset();
            this.lexer.lex(source);
            List<Token> tokens = this.tokens();
            return super.parse(tokens);
        }

        private List<Token> tokens() {
            List<Token> tokens = this.lexer.getTokens();
            if (this.lexerState.indentationStack.peek() > 0) {
                Token eofToken = tokens.get(tokens.size() - 1);
                tokens = new ArrayList<Token>(tokens.subList(0, tokens.size() - 1));
                while (this.lexerState.indentationStack.peek() > 0) {
                    this.lexerState.indentationStack.pop();
                    tokens.add(Token.builder().setURI(eofToken.getURI()).setType(PythonTokenType.DEDENT).setLine(eofToken.getLine()).setColumn(eofToken.getColumn()).setValueAndOriginalValue("").build());
                }
                tokens.add(eofToken);
            }
            return tokens;
        }
    }
}

