/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.ArgList;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Decorator;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.SimpleStatement;

public class DecoratorImpl
extends SimpleStatement
implements Decorator {
    private final Token atToken;
    private final Token newLineToken;
    private final Expression expression;

    public DecoratorImpl(Token atToken, Expression expression, @Nullable Token newLineToken) {
        this.atToken = atToken;
        this.expression = expression;
        this.newLineToken = newLineToken != null ? newLineToken : null;
    }

    @Override
    public Token atToken() {
        return this.atToken;
    }

    @Override
    @CheckForNull
    public ArgList arguments() {
        if (this.expression.is(Tree.Kind.CALL_EXPR)) {
            return ((CallExpression)this.expression).argumentList();
        }
        return null;
    }

    @Override
    public Expression expression() {
        return this.expression;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitDecorator(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(this.atToken, this.expression, this.newLineToken).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.DECORATOR;
    }
}

