/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.plugins.python.api.tree.CellMagicStatement;
import org.sonar.plugins.python.api.tree.DynamicObjectInfoStatement;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionStatement;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.LineMagic;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.DocstringExtractor;
import org.sonar.python.api.IPythonGrammar;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.tree.CellMagicStatementImpl;
import org.sonar.python.tree.DynamicObjectInfoStatementImpl;
import org.sonar.python.tree.ExceptGroupJumpInstructionsCheck;
import org.sonar.python.tree.ExpressionStatementImpl;
import org.sonar.python.tree.FileInputImpl;
import org.sonar.python.tree.LineMagicImpl;
import org.sonar.python.tree.PythonTreeMaker;
import org.sonar.python.tree.Separators;
import org.sonar.python.tree.StatementListImpl;
import org.sonar.python.tree.StatementWithSeparator;

public class IPythonTreeMaker
extends PythonTreeMaker {
    @Override
    public FileInput fileInput(AstNode astNode) {
        StatementList statementList = astNode.getChildren(IPythonGrammar.CELL, IPythonGrammar.MAGIC_CELL).stream().flatMap(this::getStatementsFromCell).collect(Collectors.collectingAndThen(Collectors.toList(), l -> l.isEmpty() ? null : new StatementListImpl((List<Statement>)l)));
        org.sonar.plugins.python.api.tree.Token endOfFile = IPythonTreeMaker.toPyToken(astNode.getFirstChild(GenericTokenType.EOF).getToken());
        FileInputImpl pyFileInputTree = new FileInputImpl(statementList, endOfFile, DocstringExtractor.extractDocstring(statementList));
        this.setParents(pyFileInputTree);
        pyFileInputTree.accept(new ExceptGroupJumpInstructionsCheck());
        return pyFileInputTree;
    }

    private Stream<Statement> getStatementsFromCell(AstNode cell) {
        if (cell.is(IPythonGrammar.CELL)) {
            return IPythonTreeMaker.getStatements(cell).stream().map(this::statement);
        }
        return Stream.of(cell.getFirstChild(IPythonGrammar.CELL_MAGIC_STATEMENT)).map(IPythonTreeMaker::cellMagicStatement);
    }

    @Override
    protected Statement statement(StatementWithSeparator statementWithSeparator) {
        AstNode astNode = statementWithSeparator.statement();
        if (astNode.is(IPythonGrammar.LINE_MAGIC_STATEMENT)) {
            return this.lineMagicStatement(astNode);
        }
        if (astNode.is(IPythonGrammar.DYNAMIC_OBJECT_INFO_STATEMENT)) {
            return this.dynamicObjectInfoStatement(astNode);
        }
        return super.statement(statementWithSeparator);
    }

    @Override
    protected Expression annotatedRhs(AstNode annotatedRhs) {
        AstNode child = annotatedRhs.getFirstChild();
        if (child.is(IPythonGrammar.LINE_MAGIC)) {
            return this.lineMagic(child);
        }
        return super.annotatedRhs(annotatedRhs);
    }

    private static CellMagicStatement cellMagicStatement(AstNode astNode) {
        List<org.sonar.plugins.python.api.tree.Token> tokens = astNode.getChildren().stream().map(AstNode::getTokens).flatMap(Collection::stream).map(PythonTreeMaker::toPyToken).collect(Collectors.toList());
        return new CellMagicStatementImpl(tokens);
    }

    protected ExpressionStatement lineMagicStatement(AstNode astNode) {
        LineMagic lineMagic = this.lineMagic(astNode.getFirstChild(IPythonGrammar.LINE_MAGIC));
        return new ExpressionStatementImpl(List.of(lineMagic), Separators.EMPTY);
    }

    protected DynamicObjectInfoStatement dynamicObjectInfoStatement(AstNode astNode) {
        ArrayList<org.sonar.plugins.python.api.tree.Token> questionMarksBefore = new ArrayList<org.sonar.plugins.python.api.tree.Token>();
        ArrayList<Tree> children = new ArrayList<Tree>();
        ArrayList<org.sonar.plugins.python.api.tree.Token> questionMarksAfter = new ArrayList<org.sonar.plugins.python.api.tree.Token>();
        List<AstNode> nodeChildren = astNode.getChildren();
        boolean isQuestionMarksBefore = true;
        for (int i = 0; i < nodeChildren.size(); ++i) {
            AstNode child = nodeChildren.get(i);
            Token childToken = child.getToken();
            if ("?".equals(childToken.getValue())) {
                if (isQuestionMarksBefore) {
                    questionMarksBefore.add(IPythonTreeMaker.toPyToken(childToken));
                    continue;
                }
                questionMarksAfter.add(IPythonTreeMaker.toPyToken(childToken));
                continue;
            }
            isQuestionMarksBefore = false;
            child.getTokens().stream().map(PythonTreeMaker::toPyToken).forEach(children::add);
        }
        return new DynamicObjectInfoStatementImpl(questionMarksBefore, children, questionMarksAfter);
    }

    protected LineMagic lineMagic(AstNode astNode) {
        org.sonar.plugins.python.api.tree.Token percent = IPythonTreeMaker.toPyToken(astNode.getFirstChild().getToken());
        org.sonar.plugins.python.api.tree.Token name = IPythonTreeMaker.toPyToken(astNode.getFirstChild(PythonGrammar.NAME).getToken());
        List<org.sonar.plugins.python.api.tree.Token> tokens = astNode.getChildren().stream().skip(2L).map(AstNode::getTokens).flatMap(Collection::stream).map(PythonTreeMaker::toPyToken).collect(Collectors.toList());
        return new LineMagicImpl(percent, name, tokens);
    }
}

