/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.plugins.python.api.tree.FormattedExpression;
import org.sonar.plugins.python.api.tree.StringElement;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class StringElementImpl
extends PyTree
implements StringElement {
    private final String value;
    private final Token token;
    private List<FormattedExpression> formattedExpressions = new ArrayList<FormattedExpression>();

    public StringElementImpl(Token token) {
        this.value = token.value();
        this.token = token;
    }

    @Override
    public Token firstToken() {
        return this.token;
    }

    @Override
    public Token lastToken() {
        return this.token;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.STRING_ELEMENT;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitStringElement(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.concat(Stream.of(this.token), this.formattedExpressions.stream()).collect(Collectors.toList());
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public String trimmedQuotesValue() {
        String trimmed = StringElementImpl.removePrefix(this.value);
        int startIndex = 1;
        if (StringElementImpl.isTripleQuote(trimmed)) {
            startIndex = 3;
        }
        return trimmed.substring(startIndex, trimmed.length() - startIndex);
    }

    @Override
    public String prefix() {
        return this.value.substring(0, StringElementImpl.prefixLength(this.value));
    }

    @Override
    public boolean isTripleQuoted() {
        return StringElementImpl.isTripleQuote(StringElementImpl.removePrefix(this.value));
    }

    @Override
    public boolean isInterpolated() {
        String prefix = this.prefix();
        return prefix.indexOf(102) >= 0 || prefix.indexOf(70) >= 0;
    }

    @Override
    public List<FormattedExpression> formattedExpressions() {
        return this.formattedExpressions;
    }

    void addFormattedExpression(FormattedExpression formattedExpression) {
        this.formattedExpressions.add(formattedExpression);
    }

    private static boolean isTripleQuote(String trimmed) {
        if (trimmed.length() >= 6) {
            char startChar = trimmed.charAt(0);
            return startChar == trimmed.charAt(1) && startChar == trimmed.charAt(2);
        }
        return false;
    }

    private static String removePrefix(String value) {
        return value.substring(StringElementImpl.prefixLength(value));
    }

    private static boolean isCharQuote(char character) {
        return character == '\'' || character == '\"';
    }

    private static int prefixLength(String value) {
        int prefixLength = 0;
        while (!StringElementImpl.isCharQuote(value.charAt(prefixLength))) {
            ++prefixLength;
        }
        return prefixLength;
    }

    public int contentStartIndex() {
        int prefixLength = StringElementImpl.prefixLength(this.value);
        if (StringElementImpl.isTripleQuote(this.value.substring(prefixLength))) {
            return prefixLength + 3;
        }
        return prefixLength + 1;
    }
}

