/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.AnyParameter;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Tuple;
import org.sonar.python.TokenLocation;
import org.sonar.python.api.PythonTokenType;

public class TreeUtils {
    private static final Set<PythonTokenType> WHITESPACE_TOKEN_TYPES = EnumSet.of(PythonTokenType.NEWLINE, PythonTokenType.INDENT, PythonTokenType.DEDENT);

    private TreeUtils() {
    }

    @CheckForNull
    public static Tree firstAncestor(Tree tree, Predicate<Tree> predicate) {
        for (Tree currentParent = tree.parent(); currentParent != null; currentParent = currentParent.parent()) {
            if (!predicate.test(currentParent)) continue;
            return currentParent;
        }
        return null;
    }

    @CheckForNull
    public static Tree firstAncestorOfKind(Tree tree, Tree.Kind ... kinds) {
        return TreeUtils.firstAncestor(tree, t -> t.is(kinds));
    }

    public static Collector<Tree, ?, Map<Tree, Tree>> groupAssignmentByParentStatementList() {
        return Collectors.toMap(tree -> TreeUtils.firstAncestor(tree, parent -> parent.is(Tree.Kind.STATEMENT_LIST)), Function.identity(), (t1, t2) -> Stream.of(t1, t2).min(TreeUtils.getTreeByPositionComparator()).get());
    }

    public static Comparator<Tree> getTreeByPositionComparator() {
        return Comparator.comparing(t -> t.firstToken().line()).thenComparing(t -> t.firstToken().column());
    }

    public static List<Token> tokens(Tree tree) {
        if (tree.is(Tree.Kind.TOKEN)) {
            return Collections.singletonList((Token)tree);
        }
        if (tree.is(Tree.Kind.STRING_ELEMENT)) {
            return Collections.singletonList(tree.firstToken());
        }
        ArrayList<Token> tokens = new ArrayList<Token>();
        for (Tree child : tree.children()) {
            if (child.is(Tree.Kind.TOKEN)) {
                tokens.add((Token)child);
                continue;
            }
            tokens.addAll(TreeUtils.tokens(child));
        }
        return tokens;
    }

    public static List<Token> nonWhitespaceTokens(Tree tree) {
        return TreeUtils.tokens(tree).stream().filter(t -> !WHITESPACE_TOKEN_TYPES.contains(t.type())).collect(Collectors.toList());
    }

    public static boolean hasDescendant(Tree tree, Predicate<Tree> predicate) {
        return tree.children().stream().anyMatch(child -> predicate.test((Tree)child) || TreeUtils.hasDescendant(child, predicate));
    }

    public static Stream<Expression> flattenTuples(Expression expression) {
        if (expression.is(Tree.Kind.TUPLE)) {
            Tuple tuple = (Tuple)expression;
            return tuple.elements().stream().flatMap(TreeUtils::flattenTuples);
        }
        return Stream.of(expression);
    }

    public static Optional<Symbol> getSymbolFromTree(@Nullable Tree tree) {
        if (tree instanceof HasSymbol) {
            return Optional.ofNullable(((HasSymbol)((Object)tree)).symbol());
        }
        return Optional.empty();
    }

    @CheckForNull
    public static ClassSymbol getClassSymbolFromDef(@Nullable ClassDef classDef) {
        if (classDef == null) {
            return null;
        }
        Symbol classNameSymbol = classDef.name().symbol();
        if (classNameSymbol == null) {
            throw new IllegalStateException("A ClassDef should always have a non-null symbol!");
        }
        if (classNameSymbol.kind() == Symbol.Kind.CLASS) {
            return (ClassSymbol)classNameSymbol;
        }
        return null;
    }

    public static List<String> getParentClassesFQN(ClassDef classDef) {
        return TreeUtils.getParentClasses(TreeUtils.getClassSymbolFromDef(classDef), new HashSet<ClassSymbol>()).stream().map(Symbol::fullyQualifiedName).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static List<Symbol> getParentClasses(@Nullable ClassSymbol classSymbol, Set<ClassSymbol> visitedSymbols) {
        ArrayList<Symbol> superClasses = new ArrayList<Symbol>();
        if (classSymbol == null || visitedSymbols.contains(classSymbol)) {
            return superClasses;
        }
        visitedSymbols.add(classSymbol);
        for (Symbol symbol : classSymbol.superClasses()) {
            superClasses.add(symbol);
            if (!(symbol instanceof ClassSymbol)) continue;
            superClasses.addAll(TreeUtils.getParentClasses((ClassSymbol)symbol, visitedSymbols));
        }
        return superClasses;
    }

    @CheckForNull
    public static FunctionSymbol getFunctionSymbolFromDef(@Nullable FunctionDef functionDef) {
        if (functionDef == null) {
            return null;
        }
        Symbol functionNameSymbol = functionDef.name().symbol();
        if (functionNameSymbol == null) {
            throw new IllegalStateException("A FunctionDef should always have a non-null symbol!");
        }
        if (functionNameSymbol.kind() == Symbol.Kind.FUNCTION) {
            return (FunctionSymbol)functionNameSymbol;
        }
        return null;
    }

    public static List<Parameter> nonTupleParameters(FunctionDef functionDef) {
        ParameterList parameterList = functionDef.parameters();
        if (parameterList == null) {
            return Collections.emptyList();
        }
        return parameterList.nonTuple();
    }

    public static List<Parameter> positionalParameters(FunctionDef functionDef) {
        ParameterList parameterList = functionDef.parameters();
        if (parameterList == null) {
            return Collections.emptyList();
        }
        ArrayList<Parameter> result = new ArrayList<Parameter>();
        for (AnyParameter anyParameter : parameterList.all()) {
            if (!(anyParameter instanceof Parameter)) continue;
            Parameter parameter = (Parameter)anyParameter;
            Token starToken = parameter.starToken();
            if (parameter.name() == null && starToken != null) {
                if (!"*".equals(starToken.value())) continue;
                return result;
            }
            result.add(parameter);
        }
        return result;
    }

    public static List<FunctionDef> topLevelFunctionDefs(ClassDef classDef) {
        CollectFunctionDefsVisitor visitor = new CollectFunctionDefsVisitor();
        classDef.body().accept(visitor);
        return visitor.functionDefs;
    }

    public static int findIndentationSize(Tree tree) {
        Tree parent = tree.parent();
        if (parent == null) {
            return TreeUtils.findIndentDownTree(tree);
        }
        Token treeToken = tree.firstToken();
        Token parentToken = parent.firstToken();
        if (treeToken.line() != parentToken.line()) {
            return treeToken.column() - parentToken.column();
        }
        return TreeUtils.findIndentationSize(parent);
    }

    private static int findIndentDownTree(Tree parent) {
        Token parentToken = parent.firstToken();
        return parent.children().stream().map(child -> {
            Token childToken = child.firstToken();
            if (childToken.line() > parentToken.line() && childToken.column() > parentToken.column()) {
                return childToken.column() - parentToken.column();
            }
            return TreeUtils.findIndentDownTree(child);
        }).filter(i -> i > 0).findFirst().orElse(0);
    }

    @CheckForNull
    public static RegularArgument argumentByKeyword(String keyword, List<Argument> arguments) {
        for (int i = 0; i < arguments.size(); ++i) {
            Argument argument = arguments.get(i);
            if (!TreeUtils.hasKeyword(argument, keyword)) continue;
            return (RegularArgument)argument;
        }
        return null;
    }

    @CheckForNull
    public static RegularArgument nthArgumentOrKeyword(int argPosition, String keyword, List<Argument> arguments) {
        for (int i = 0; i < arguments.size(); ++i) {
            RegularArgument regularArgument;
            Argument argument = arguments.get(i);
            if (TreeUtils.hasKeyword(argument, keyword)) {
                return (RegularArgument)argument;
            }
            if (!argument.is(Tree.Kind.REGULAR_ARGUMENT) || (regularArgument = (RegularArgument)argument).keywordArgument() != null || argPosition != i) continue;
            return regularArgument;
        }
        return null;
    }

    private static boolean hasKeyword(Argument argument, String keyword) {
        if (argument.is(Tree.Kind.REGULAR_ARGUMENT)) {
            Name keywordArgument = ((RegularArgument)argument).keywordArgument();
            return keywordArgument != null && keywordArgument.name().equals(keyword);
        }
        return false;
    }

    public static boolean isBooleanLiteral(Tree tree) {
        if (tree.is(Tree.Kind.NAME)) {
            String name = ((Name)tree).name();
            return name.equals("True") || name.equals("False");
        }
        return false;
    }

    public static String nameFromExpression(Expression expression) {
        if (expression.is(Tree.Kind.NAME)) {
            return ((Name)expression).name();
        }
        return null;
    }

    public static String nameFromQualifiedExpression(QualifiedExpression qualifiedExpression) {
        Object exprName = qualifiedExpression.name().name();
        Expression qualifier = qualifiedExpression.qualifier();
        String nameOfQualifier = TreeUtils.decoratorNameFromExpression(qualifier);
        exprName = nameOfQualifier != null ? nameOfQualifier + "." + (String)exprName : null;
        return exprName;
    }

    @CheckForNull
    public static String decoratorNameFromExpression(Expression expression) {
        if (expression.is(Tree.Kind.NAME)) {
            return ((Name)expression).name();
        }
        if (expression.is(Tree.Kind.QUALIFIED_EXPR)) {
            return TreeUtils.nameFromQualifiedExpression((QualifiedExpression)expression);
        }
        if (expression.is(Tree.Kind.CALL_EXPR)) {
            return TreeUtils.decoratorNameFromExpression(((CallExpression)expression).callee());
        }
        return null;
    }

    public static String fullyQualifiedNameFromQualifiedExpression(QualifiedExpression qualifiedExpression) {
        Object exprName = qualifiedExpression.name().name();
        Expression qualifier = qualifiedExpression.qualifier();
        String nameOfQualifier = TreeUtils.fullyQualifiedNameFromExpression(qualifier);
        exprName = nameOfQualifier != null ? nameOfQualifier + "." + (String)exprName : null;
        return exprName;
    }

    @CheckForNull
    public static String fullyQualifiedNameFromExpression(Expression expression) {
        if (expression.is(Tree.Kind.NAME)) {
            Symbol symbol = ((Name)expression).symbol();
            return symbol != null ? symbol.fullyQualifiedName() : ((Name)expression).name();
        }
        if (expression.is(Tree.Kind.QUALIFIED_EXPR)) {
            return TreeUtils.fullyQualifiedNameFromQualifiedExpression((QualifiedExpression)expression);
        }
        if (expression.is(Tree.Kind.CALL_EXPR)) {
            return TreeUtils.fullyQualifiedNameFromExpression(((CallExpression)expression).callee());
        }
        return null;
    }

    @CheckForNull
    public static LocationInFile locationInFile(Tree tree, @Nullable String fileId) {
        if (fileId == null) {
            return null;
        }
        TokenLocation firstToken = new TokenLocation(tree.firstToken());
        TokenLocation lastToken = new TokenLocation(tree.lastToken());
        return new LocationInFile(fileId, firstToken.startLine(), firstToken.startLineOffset(), lastToken.endLine(), lastToken.endLineOffset());
    }

    public static Token getTreeSeparatorOrLastToken(Tree tree) {
        Token separator;
        if (tree instanceof Statement && (separator = ((Statement)tree).separator()) != null) {
            return separator;
        }
        return tree.lastToken();
    }

    public static <T extends Tree> Function<Tree, T> toInstanceOfMapper(Class<T> castToClass) {
        return TreeUtils.toOptionalInstanceOfMapper(castToClass).andThen(t -> t.orElse(null));
    }

    public static <T extends Tree> Function<Tree, Optional<T>> toOptionalInstanceOfMapper(Class<T> castToClass) {
        return tree -> TreeUtils.toOptionalInstanceOf(castToClass, tree);
    }

    public static <T extends Tree> Optional<T> toOptionalInstanceOf(Class<T> castToClass, Tree tree) {
        return Optional.of(tree).filter(castToClass::isInstance).map(castToClass::cast);
    }

    public static Optional<Tree> firstChild(Tree tree, Predicate<Tree> filter) {
        if (filter.test(tree)) {
            return Optional.of(tree);
        }
        return tree.children().stream().map(c -> TreeUtils.firstChild(c, filter)).filter(Optional::isPresent).findFirst().map(Optional::get);
    }

    public static String treeToString(Tree tree, boolean renderMultiline) {
        int lastLine;
        int firstLine;
        if (!renderMultiline && (firstLine = tree.firstToken().line()) != (lastLine = tree.lastToken().line())) {
            return null;
        }
        List<Token> tokens = TreeUtils.tokens(tree);
        StringBuilder valueBuilder = new StringBuilder();
        for (int i = 0; i < tokens.size(); ++i) {
            Token token = tokens.get(i);
            if (i > 0) {
                Token previous = tokens.get(i - 1);
                int spaceBetween = token.column() - previous.column() - previous.value().length();
                if (spaceBetween < 0) {
                    spaceBetween = token.column();
                }
                valueBuilder.append(" ".repeat(spaceBetween));
            }
            valueBuilder.append(token.value());
        }
        return valueBuilder.toString();
    }

    private static class CollectFunctionDefsVisitor
    extends BaseTreeVisitor {
        private List<FunctionDef> functionDefs = new ArrayList<FunctionDef>();

        private CollectFunctionDefsVisitor() {
        }

        @Override
        public void visitClassDef(ClassDef pyClassDefTree) {
        }

        @Override
        public void visitFunctionDef(FunctionDef pyFunctionDefTree) {
            this.functionDefs.add(pyFunctionDefTree);
        }
    }
}

