/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.finders;

import java.util.Collections;
import org.sonarsource.analyzer.commons.regex.RegexIssueLocation;
import org.sonarsource.analyzer.commons.regex.RegexIssueReporter;
import org.sonarsource.analyzer.commons.regex.ast.AutomatonState;
import org.sonarsource.analyzer.commons.regex.ast.FinalState;
import org.sonarsource.analyzer.commons.regex.ast.Quantifier;
import org.sonarsource.analyzer.commons.regex.ast.RegexSyntaxElement;
import org.sonarsource.analyzer.commons.regex.ast.RepetitionTree;
import org.sonarsource.analyzer.commons.regex.helpers.BranchTrackingVisitor;
import org.sonarsource.analyzer.commons.regex.helpers.RegexTreeHelper;
import org.sonarsource.analyzer.commons.regex.helpers.SubAutomaton;

public class PossessiveQuantifierContinuationFinder
extends BranchTrackingVisitor {
    private static final String MESSAGE = "Change this impossible to match sub-pattern that conflicts with the previous possessive quantifier.";
    private final RegexIssueReporter.ElementIssue regexElementIssueReporter;
    private final FinalState finalState;

    public PossessiveQuantifierContinuationFinder(RegexIssueReporter.ElementIssue regexElementIssueReporter, FinalState finalState) {
        this.regexElementIssueReporter = regexElementIssueReporter;
        this.finalState = finalState;
    }

    @Override
    public void visitRepetition(RepetitionTree repetitionTree) {
        AutomatonState continuation;
        for (continuation = repetitionTree.continuation(); continuation != null && !(continuation instanceof RegexSyntaxElement); continuation = continuation.continuation()) {
        }
        if (continuation != null && this.doesRepetitionContinuationAlwaysFail(repetitionTree)) {
            this.regexElementIssueReporter.report((RegexSyntaxElement)((Object)continuation), MESSAGE, null, Collections.singletonList(new RegexIssueLocation(repetitionTree, "Previous possessive repetition")));
        }
        super.visitRepetition(repetitionTree);
    }

    private boolean doesRepetitionContinuationAlwaysFail(RepetitionTree repetitionTree) {
        Quantifier quantifier = repetitionTree.getQuantifier();
        if (!quantifier.isOpenEnded() || quantifier.getModifier() != Quantifier.Modifier.POSSESSIVE) {
            return false;
        }
        SubAutomaton potentialSuperset = new SubAutomaton(repetitionTree.getElement(), repetitionTree.getElement().continuation(), false);
        SubAutomaton potentialSubset = new SubAutomaton(repetitionTree.continuation(), this.finalState, this.getPredecessorsRangeOf(repetitionTree), true);
        return RegexTreeHelper.supersetOf(potentialSuperset, potentialSubset, false);
    }
}

