/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.finders;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonarsource.analyzer.commons.regex.MatchType;
import org.sonarsource.analyzer.commons.regex.RegexIssueReporter;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.ast.AtomicGroupTree;
import org.sonarsource.analyzer.commons.regex.ast.AutomatonState;
import org.sonarsource.analyzer.commons.regex.ast.BackReferenceTree;
import org.sonarsource.analyzer.commons.regex.ast.CharacterClassElementTree;
import org.sonarsource.analyzer.commons.regex.ast.DisjunctionTree;
import org.sonarsource.analyzer.commons.regex.ast.DotTree;
import org.sonarsource.analyzer.commons.regex.ast.GroupTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;
import org.sonarsource.analyzer.commons.regex.ast.RegexTree;
import org.sonarsource.analyzer.commons.regex.ast.RepetitionTree;
import org.sonarsource.analyzer.commons.regex.helpers.IntersectAutomataChecker;
import org.sonarsource.analyzer.commons.regex.helpers.RegexReachabilityChecker;
import org.sonarsource.analyzer.commons.regex.helpers.RegexTreeHelper;
import org.sonarsource.analyzer.commons.regex.helpers.SimplifiedRegexCharacterClass;
import org.sonarsource.analyzer.commons.regex.helpers.SubAutomaton;

public abstract class RedosFinder {
    private final RegexReachabilityChecker reachabilityChecker = new RegexReachabilityChecker(false);
    private final IntersectAutomataChecker intersectionChecker = new IntersectAutomataChecker(false);
    private static final int MAX_TRACKED_REPETITIONS = 10;
    private static final int MAX_REGEX_LENGTH = 1000;
    private boolean regexContainsBackReference;
    private BacktrackingType foundBacktrackingType;

    protected abstract Optional<String> message(BacktrackingType var1, boolean var2);

    public void checkRegex(RegexParseResult regexForLiterals, MatchType matchType, RegexIssueReporter.ElementIssue regexElementIssueReporter) {
        if (regexForLiterals.getResult().getText().length() > 1000) {
            return;
        }
        this.regexContainsBackReference = false;
        this.foundBacktrackingType = BacktrackingType.NO_ISSUE;
        this.reachabilityChecker.clearCache();
        this.intersectionChecker.clearCache();
        boolean isUsedForFullMatch = matchType == MatchType.FULL || matchType == MatchType.BOTH;
        boolean isUsedForPartialMatch = matchType == MatchType.PARTIAL || matchType == MatchType.BOTH;
        RedosVisitor visitor = new RedosVisitor(regexForLiterals.getStartState(), regexForLiterals.getFinalState(), isUsedForFullMatch, isUsedForPartialMatch);
        visitor.visit(regexForLiterals);
        this.message(this.foundBacktrackingType, this.regexContainsBackReference).ifPresent(m -> regexElementIssueReporter.report(regexForLiterals.getResult(), (String)m, null, Collections.emptyList()));
    }

    private void addBacktracking(BacktrackingType newBacktrackingType) {
        this.foundBacktrackingType = this.foundBacktrackingType.max(newBacktrackingType);
    }

    private class BacktrackingFinder
    extends RegexBaseVisitor {
        private final boolean isReluctant;
        private final AutomatonState endOfLoop;

        public BacktrackingFinder(boolean isReluctant, AutomatonState endOfLoop) {
            this.isReluctant = isReluctant;
            this.endOfLoop = endOfLoop;
        }

        @Override
        public void visitAtomicGroup(AtomicGroupTree tree) {
            new RedosVisitor(tree, tree.continuation(), false, false).visit(tree);
        }

        @Override
        public void visitRepetition(RepetitionTree tree) {
            if (tree.isPossessive()) {
                new RedosVisitor(tree, tree.continuation(), false, false).visit(tree);
            } else if (this.containsIntersections(List.of(tree.getElement(), tree.continuation()))) {
                BacktrackingType greedyComplexity = tree.getQuantifier().isOpenEnded() ? BacktrackingType.QUADRATIC_WHEN_OPTIMIZED : BacktrackingType.LINEAR_WHEN_OPTIMIZED;
                RedosFinder.this.addBacktracking(this.isReluctant ? BacktrackingType.ALWAYS_EXPONENTIAL : greedyComplexity);
                super.visitRepetition(tree);
            } else {
                super.visitRepetition(tree);
            }
        }

        @Override
        public void visitDisjunction(DisjunctionTree tree) {
            if (this.containsIntersections(tree.getAlternatives())) {
                RedosFinder.this.addBacktracking(this.isReluctant ? BacktrackingType.ALWAYS_EXPONENTIAL : BacktrackingType.LINEAR_WHEN_OPTIMIZED);
            } else {
                super.visitDisjunction(tree);
            }
        }

        @Override
        public void visitBackReference(BackReferenceTree tree) {
            RedosFinder.this.regexContainsBackReference = true;
        }

        boolean containsIntersections(List<? extends AutomatonState> alternatives) {
            for (int i = 0; i < alternatives.size() - 1; ++i) {
                AutomatonState state1 = alternatives.get(i);
                for (int j = i + 1; j < alternatives.size(); ++j) {
                    SubAutomaton auto1 = new SubAutomaton(state1, this.endOfLoop, false);
                    AutomatonState state2 = alternatives.get(j);
                    SubAutomaton auto2 = new SubAutomaton(state2, this.endOfLoop, false);
                    if (!RedosFinder.this.intersectionChecker.check(auto1, auto2)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private class RedosVisitor
    extends RegexBaseVisitor {
        private final Deque<RepetitionTree> nonPossessiveRepetitions = new ArrayDeque<RepetitionTree>();
        private final Map<AutomatonState, Boolean> canFailCache = new HashMap<AutomatonState, Boolean>();
        private final AutomatonState startOfRegex;
        private final AutomatonState endOfRegex;
        private final boolean isUsedForFullMatch;
        private final boolean isUsedForPartialMatch;

        public RedosVisitor(AutomatonState startOfRegex, AutomatonState endOfRegex, boolean isUsedForFullMatch, boolean isUsedForPartialMatch) {
            this.startOfRegex = startOfRegex;
            this.endOfRegex = endOfRegex;
            this.isUsedForFullMatch = isUsedForFullMatch;
            this.isUsedForPartialMatch = isUsedForPartialMatch;
        }

        @Override
        public void visitRepetition(RepetitionTree tree) {
            if (this.canFail(tree.continuation())) {
                if (!tree.isPossessive() && tree.getQuantifier().isOpenEnded()) {
                    new BacktrackingFinder(tree.isReluctant(), tree.continuation()).visit(tree.getElement());
                } else {
                    super.visitRepetition(tree);
                }
                this.checkForOverlappingRepetitions(tree);
            }
        }

        private void checkForOverlappingRepetitions(RepetitionTree tree) {
            if (tree.getQuantifier().isOpenEnded() && this.canFail(tree)) {
                for (RepetitionTree repetition : this.nonPossessiveRepetitions) {
                    if (!RedosFinder.this.reachabilityChecker.canReach(repetition, tree)) continue;
                    SubAutomaton repetitionAuto = new SubAutomaton(repetition.getElement(), repetition.continuation(), false);
                    SubAutomaton continuationAuto = new SubAutomaton(repetition.continuation(), tree, false);
                    SubAutomaton treeAuto = new SubAutomaton(tree.getElement(), tree.continuation(), false);
                    if (!this.subAutomatonCanConsume(repetitionAuto, continuationAuto) || !this.automatonIsEmptyOrIntersects(continuationAuto, treeAuto) || !RedosFinder.this.intersectionChecker.check(repetitionAuto, treeAuto)) continue;
                    RedosFinder.this.addBacktracking(BacktrackingType.ALWAYS_QUADRATIC);
                }
                if (this.overlapsWithImplicitMatchAlls(tree)) {
                    RedosFinder.this.addBacktracking(BacktrackingType.ALWAYS_QUADRATIC);
                }
                this.addIfNonPossessive(tree);
            }
        }

        private boolean subAutomatonCanConsume(SubAutomaton auto1, SubAutomaton auto2) {
            return RegexReachabilityChecker.canReachWithoutConsumingInputNorCrossingBoundaries(auto1.end, auto2.end) || RedosFinder.this.intersectionChecker.check(auto1, auto2);
        }

        private boolean automatonIsEmptyOrIntersects(SubAutomaton auto1, SubAutomaton auto2) {
            return RegexReachabilityChecker.canReachWithoutConsumingInputNorCrossingBoundaries(auto1.start, auto1.end) || RedosFinder.this.intersectionChecker.check(auto1, auto2);
        }

        private void addIfNonPossessive(RepetitionTree tree) {
            if (!tree.isPossessive()) {
                this.nonPossessiveRepetitions.add(tree);
                if (this.nonPossessiveRepetitions.size() > 10) {
                    this.nonPossessiveRepetitions.removeFirst();
                }
            }
        }

        private boolean overlapsWithImplicitMatchAlls(RepetitionTree tree) {
            return this.isUsedForPartialMatch && RegexReachabilityChecker.canReachWithoutConsumingInputNorCrossingBoundaries(this.startOfRegex, tree);
        }

        @Override
        public void visitBackReference(BackReferenceTree tree) {
            RedosFinder.this.regexContainsBackReference = true;
        }

        private boolean canFail(AutomatonState state) {
            return this.canFail(state, !this.isUsedForFullMatch && !RegexTreeHelper.isAnchoredAtEnd(state));
        }

        private boolean canFail(AutomatonState state, boolean succeedOnEnd) {
            if (this.canFailCache.containsKey(state)) {
                return this.canFailCache.get(state);
            }
            this.canFailCache.put(state, true);
            if (state.incomingTransitionType() != AutomatonState.TransitionType.EPSILON) {
                return true;
            }
            if (this.canMatchAnything(state)) {
                succeedOnEnd = true;
                state = state.continuation();
            }
            if (succeedOnEnd && RegexReachabilityChecker.canReachWithoutConsumingInput(state, this.endOfRegex)) {
                this.canFailCache.put(state, false);
                return false;
            }
            for (AutomatonState automatonState : state.successors()) {
                if (this.canFail(automatonState, succeedOnEnd)) continue;
                this.canFailCache.put(state, false);
                return false;
            }
            return true;
        }

        private boolean canMatchAnything(AutomatonState state) {
            if (!(state instanceof RepetitionTree)) {
                return false;
            }
            RepetitionTree repetition = (RepetitionTree)state;
            return repetition.getQuantifier().getMinimumRepetitions() == 0 && repetition.getQuantifier().isOpenEnded() && this.canMatchAnyCharacter(repetition.getElement());
        }

        private boolean canMatchAnyCharacter(RegexTree tree) {
            SimplifiedRegexCharacterClass characterClass = new SimplifiedRegexCharacterClass();
            for (RegexTree singleCharacter : this.collectSingleCharacters(tree, new ArrayList<RegexTree>())) {
                if (singleCharacter.is(RegexTree.Kind.DOT)) {
                    characterClass.add((DotTree)singleCharacter);
                    continue;
                }
                characterClass.add((CharacterClassElementTree)((Object)singleCharacter));
            }
            return characterClass.matchesAnyCharacter();
        }

        private List<RegexTree> collectSingleCharacters(@Nullable RegexTree tree, List<RegexTree> accumulator) {
            RepetitionTree repetition;
            if (tree == null) {
                return accumulator;
            }
            if (tree instanceof CharacterClassElementTree || tree.is(RegexTree.Kind.DOT)) {
                accumulator.add(tree);
            } else if (tree.is(RegexTree.Kind.DISJUNCTION)) {
                for (RegexTree alternative : ((DisjunctionTree)tree).getAlternatives()) {
                    this.collectSingleCharacters(alternative, accumulator);
                }
            } else if (tree instanceof GroupTree) {
                this.collectSingleCharacters(((GroupTree)tree).getElement(), accumulator);
            } else if (tree.is(RegexTree.Kind.REPETITION) && (repetition = (RepetitionTree)tree).getQuantifier().getMinimumRepetitions() <= 1) {
                this.collectSingleCharacters(repetition.getElement(), accumulator);
            }
            return accumulator;
        }
    }

    public static enum BacktrackingType {
        NO_ISSUE(0),
        LINEAR_WHEN_OPTIMIZED(1),
        ALWAYS_QUADRATIC(2),
        QUADRATIC_WHEN_OPTIMIZED(3),
        ALWAYS_EXPONENTIAL(4);

        private final int priority;

        private BacktrackingType(int priority) {
            this.priority = priority;
        }

        public BacktrackingType max(BacktrackingType another) {
            return this.priority > another.priority ? this : another;
        }
    }
}

