/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.finders;

import java.util.Collections;
import org.sonarsource.analyzer.commons.regex.RegexIssueReporter;
import org.sonarsource.analyzer.commons.regex.ast.Quantifier;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;
import org.sonarsource.analyzer.commons.regex.ast.RepetitionTree;

public class SuperfluousCurlyBraceFinder
extends RegexBaseVisitor {
    public static final String REMOVE_UNNECESSARY_QUANTIFIER = "Remove this unnecessary quantifier.";
    public static final String REMOVE_UNNECESSARILY_QUANTIFIED_EXPRESSION = "Remove this unnecessarily quantified expression.";
    private final RegexIssueReporter.ElementIssue regexElementIssueReporter;

    public SuperfluousCurlyBraceFinder(RegexIssueReporter.ElementIssue regexElementIssueReporter) {
        this.regexElementIssueReporter = regexElementIssueReporter;
    }

    @Override
    public void visitRepetition(RepetitionTree tree) {
        Quantifier quantifier = tree.getQuantifier();
        int min = quantifier.getMinimumRepetitions();
        Integer max = quantifier.getMaximumRepetitions();
        if (max != null && max == min) {
            if (min == 1) {
                super.visitRepetition(tree);
                this.regexElementIssueReporter.report(quantifier, REMOVE_UNNECESSARY_QUANTIFIER, null, Collections.emptyList());
            } else if (min == 0) {
                this.regexElementIssueReporter.report(tree, REMOVE_UNNECESSARILY_QUANTIFIED_EXPRESSION, null, Collections.emptyList());
            }
        }
    }
}

