/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.phase;

import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.PainlessError;
import org.elasticsearch.painless.PainlessExplainError;
import org.elasticsearch.painless.ScriptClassInfo;
import org.elasticsearch.painless.ir.BinaryImplNode;
import org.elasticsearch.painless.ir.BlockNode;
import org.elasticsearch.painless.ir.CatchNode;
import org.elasticsearch.painless.ir.ConstantNode;
import org.elasticsearch.painless.ir.DeclarationNode;
import org.elasticsearch.painless.ir.ExpressionNode;
import org.elasticsearch.painless.ir.FieldNode;
import org.elasticsearch.painless.ir.FunctionNode;
import org.elasticsearch.painless.ir.IRNode;
import org.elasticsearch.painless.ir.InvokeCallDefNode;
import org.elasticsearch.painless.ir.InvokeCallMemberNode;
import org.elasticsearch.painless.ir.InvokeCallNode;
import org.elasticsearch.painless.ir.LoadFieldMemberNode;
import org.elasticsearch.painless.ir.LoadVariableNode;
import org.elasticsearch.painless.ir.NullNode;
import org.elasticsearch.painless.ir.ReturnNode;
import org.elasticsearch.painless.ir.StaticNode;
import org.elasticsearch.painless.ir.ThrowNode;
import org.elasticsearch.painless.ir.TryNode;
import org.elasticsearch.painless.lookup.PainlessLookup;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.lookup.def;
import org.elasticsearch.painless.node.AStatement;
import org.elasticsearch.painless.node.ECallLocal;
import org.elasticsearch.painless.node.SExpression;
import org.elasticsearch.painless.node.SFunction;
import org.elasticsearch.painless.node.SReturn;
import org.elasticsearch.painless.phase.DefaultUserTreeToIRTreePhase;
import org.elasticsearch.painless.symbol.Decorations;
import org.elasticsearch.painless.symbol.FunctionTable;
import org.elasticsearch.painless.symbol.IRDecorations;
import org.elasticsearch.painless.symbol.ScriptScope;
import org.elasticsearch.script.ScriptException;
import org.objectweb.asm.commons.Method;

public class PainlessUserTreeToIRTreePhase
extends DefaultUserTreeToIRTreePhase {
    @Override
    public void visitFunction(SFunction userFunctionNode, ScriptScope scriptScope) {
        String functionName = userFunctionNode.getFunctionName();
        if ("execute".equals(functionName)) {
            ScriptClassInfo scriptClassInfo = scriptScope.getScriptClassInfo();
            FunctionTable.LocalFunction localFunction = scriptScope.getFunctionTable().getFunction(functionName, scriptClassInfo.getExecuteArguments().size());
            Class<?> returnType = localFunction.getReturnType();
            boolean methodEscape = scriptScope.getCondition(userFunctionNode, Decorations.MethodEscape.class);
            BlockNode irBlockNode = (BlockNode)this.visit(userFunctionNode.getBlockNode(), scriptScope);
            if (!methodEscape) {
                ExpressionNode irExpressionNode;
                if (returnType == Void.TYPE) {
                    irExpressionNode = null;
                } else if (returnType.isPrimitive()) {
                    ConstantNode irConstantNode = new ConstantNode(userFunctionNode.getLocation());
                    irConstantNode.attachDecoration(new IRDecorations.IRDExpressionType(returnType));
                    if (returnType == Boolean.TYPE) {
                        irConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)false));
                    } else if (returnType == Byte.TYPE || returnType == Character.TYPE || returnType == Short.TYPE || returnType == Integer.TYPE) {
                        irConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)0));
                    } else if (returnType == Long.TYPE) {
                        irConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)0L));
                    } else if (returnType == Float.TYPE) {
                        irConstantNode.attachDecoration(new IRDecorations.IRDConstant(Float.valueOf(0.0f)));
                    } else if (returnType == Double.TYPE) {
                        irConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)0.0));
                    } else {
                        throw userFunctionNode.createError(new IllegalStateException("illegal tree structure"));
                    }
                    irExpressionNode = irConstantNode;
                } else {
                    irExpressionNode = new NullNode(userFunctionNode.getLocation());
                    irExpressionNode.attachDecoration(new IRDecorations.IRDExpressionType(returnType));
                }
                ReturnNode irReturnNode = new ReturnNode(userFunctionNode.getLocation());
                irReturnNode.setExpressionNode(irExpressionNode);
                irBlockNode.addStatementNode(irReturnNode);
            }
            List<String> parameterNames = scriptClassInfo.getExecuteArguments().stream().map(ScriptClassInfo.MethodArgument::name).toList();
            FunctionNode irFunctionNode = new FunctionNode(userFunctionNode.getLocation());
            irFunctionNode.setBlockNode(irBlockNode);
            irFunctionNode.attachDecoration(new IRDecorations.IRDName("execute"));
            irFunctionNode.attachDecoration(new IRDecorations.IRDReturnType(returnType));
            irFunctionNode.attachDecoration(new IRDecorations.IRDTypeParameters(localFunction.getTypeParameters()));
            irFunctionNode.attachDecoration(new IRDecorations.IRDParameterNames(parameterNames));
            irFunctionNode.attachDecoration(new IRDecorations.IRDMaxLoopCounter(scriptScope.getCompilerSettings().getMaxLoopCounter()));
            this.injectStaticFieldsAndGetters();
            this.injectGetsDeclarations(irBlockNode, scriptScope);
            this.injectNeedsMethods(scriptScope);
            this.injectSandboxExceptions(irFunctionNode);
            scriptScope.putDecoration(userFunctionNode, new Decorations.IRNodeDecoration(irFunctionNode));
        } else {
            super.visitFunction(userFunctionNode, scriptScope);
        }
    }

    protected void injectStaticFieldsAndGetters() {
        Location internalLocation = new Location("$internal$ScriptInjectionPhase$injectStaticFieldsAndGetters", 0);
        int modifiers = 9;
        FieldNode irFieldNode = new FieldNode(internalLocation);
        irFieldNode.attachDecoration(new IRDecorations.IRDModifiers(modifiers));
        irFieldNode.attachDecoration(new IRDecorations.IRDFieldType(String.class));
        irFieldNode.attachDecoration(new IRDecorations.IRDName("$NAME"));
        this.irClassNode.addFieldNode(irFieldNode);
        irFieldNode = new FieldNode(internalLocation);
        irFieldNode.attachDecoration(new IRDecorations.IRDModifiers(modifiers));
        irFieldNode.attachDecoration(new IRDecorations.IRDFieldType(String.class));
        irFieldNode.attachDecoration(new IRDecorations.IRDName("$SOURCE"));
        this.irClassNode.addFieldNode(irFieldNode);
        irFieldNode = new FieldNode(internalLocation);
        irFieldNode.attachDecoration(new IRDecorations.IRDModifiers(modifiers));
        irFieldNode.attachDecoration(new IRDecorations.IRDFieldType(BitSet.class));
        irFieldNode.attachDecoration(new IRDecorations.IRDName("$STATEMENTS"));
        this.irClassNode.addFieldNode(irFieldNode);
        FunctionNode irFunctionNode = new FunctionNode(internalLocation);
        irFunctionNode.attachDecoration(new IRDecorations.IRDName("getName"));
        irFunctionNode.attachDecoration(new IRDecorations.IRDReturnType(String.class));
        irFunctionNode.attachDecoration(new IRDecorations.IRDTypeParameters(List.of()));
        irFunctionNode.attachDecoration(new IRDecorations.IRDParameterNames(List.of()));
        irFunctionNode.attachCondition(IRDecorations.IRCSynthetic.class);
        irFunctionNode.attachDecoration(new IRDecorations.IRDMaxLoopCounter(0));
        this.irClassNode.addFunctionNode(irFunctionNode);
        BlockNode irBlockNode = new BlockNode(internalLocation);
        irBlockNode.attachCondition(IRDecorations.IRCAllEscape.class);
        irFunctionNode.setBlockNode(irBlockNode);
        ReturnNode irReturnNode = new ReturnNode(internalLocation);
        irBlockNode.addStatementNode(irReturnNode);
        LoadFieldMemberNode irLoadFieldMemberNode = new LoadFieldMemberNode(internalLocation);
        irLoadFieldMemberNode.attachDecoration(new IRDecorations.IRDExpressionType(String.class));
        irLoadFieldMemberNode.attachDecoration(new IRDecorations.IRDName("$NAME"));
        irLoadFieldMemberNode.attachCondition(IRDecorations.IRCStatic.class);
        irReturnNode.setExpressionNode(irLoadFieldMemberNode);
        irFunctionNode = new FunctionNode(internalLocation);
        irFunctionNode.attachDecoration(new IRDecorations.IRDName("getSource"));
        irFunctionNode.attachDecoration(new IRDecorations.IRDReturnType(String.class));
        irFunctionNode.attachDecoration(new IRDecorations.IRDTypeParameters(List.of()));
        irFunctionNode.attachDecoration(new IRDecorations.IRDParameterNames(List.of()));
        irFunctionNode.attachCondition(IRDecorations.IRCSynthetic.class);
        irFunctionNode.attachDecoration(new IRDecorations.IRDMaxLoopCounter(0));
        this.irClassNode.addFunctionNode(irFunctionNode);
        irBlockNode = new BlockNode(internalLocation);
        irBlockNode.attachCondition(IRDecorations.IRCAllEscape.class);
        irFunctionNode.setBlockNode(irBlockNode);
        irReturnNode = new ReturnNode(internalLocation);
        irBlockNode.addStatementNode(irReturnNode);
        irLoadFieldMemberNode = new LoadFieldMemberNode(internalLocation);
        irLoadFieldMemberNode.attachDecoration(new IRDecorations.IRDExpressionType(String.class));
        irLoadFieldMemberNode.attachDecoration(new IRDecorations.IRDName("$SOURCE"));
        irLoadFieldMemberNode.attachCondition(IRDecorations.IRCStatic.class);
        irReturnNode.setExpressionNode(irLoadFieldMemberNode);
        irFunctionNode = new FunctionNode(internalLocation);
        irFunctionNode.attachDecoration(new IRDecorations.IRDName("getStatements"));
        irFunctionNode.attachDecoration(new IRDecorations.IRDReturnType(BitSet.class));
        irFunctionNode.attachDecoration(new IRDecorations.IRDTypeParameters(List.of()));
        irFunctionNode.attachDecoration(new IRDecorations.IRDParameterNames(List.of()));
        irFunctionNode.attachCondition(IRDecorations.IRCSynthetic.class);
        irFunctionNode.attachDecoration(new IRDecorations.IRDMaxLoopCounter(0));
        this.irClassNode.addFunctionNode(irFunctionNode);
        irBlockNode = new BlockNode(internalLocation);
        irBlockNode.attachCondition(IRDecorations.IRCAllEscape.class);
        irFunctionNode.setBlockNode(irBlockNode);
        irReturnNode = new ReturnNode(internalLocation);
        irBlockNode.addStatementNode(irReturnNode);
        irLoadFieldMemberNode = new LoadFieldMemberNode(internalLocation);
        irLoadFieldMemberNode.attachDecoration(new IRDecorations.IRDExpressionType(BitSet.class));
        irLoadFieldMemberNode.attachDecoration(new IRDecorations.IRDName("$STATEMENTS"));
        irLoadFieldMemberNode.attachCondition(IRDecorations.IRCStatic.class);
        irReturnNode.setExpressionNode(irLoadFieldMemberNode);
    }

    protected void injectGetsDeclarations(BlockNode irBlockNode, ScriptScope scriptScope) {
        Location internalLocation = new Location("$internal$ScriptInjectionPhase$injectGetsDeclarations", 0);
        for (int i = 0; i < scriptScope.getScriptClassInfo().getGetMethods().size(); ++i) {
            Method getMethod = scriptScope.getScriptClassInfo().getGetMethods().get(i);
            Object name = getMethod.getName().substring(3);
            name = Character.toLowerCase(((String)name).charAt(0)) + ((String)name).substring(1);
            if (!scriptScope.getUsedVariables().contains(name)) continue;
            Class<?> returnType = scriptScope.getScriptClassInfo().getGetReturns().get(i);
            DeclarationNode irDeclarationNode = new DeclarationNode(internalLocation);
            irDeclarationNode.attachDecoration(new IRDecorations.IRDName((String)name));
            irDeclarationNode.attachDecoration(new IRDecorations.IRDDeclarationType(returnType));
            irBlockNode.getStatementsNodes().add(0, irDeclarationNode);
            InvokeCallMemberNode irInvokeCallMemberNode = new InvokeCallMemberNode(internalLocation);
            irInvokeCallMemberNode.attachDecoration(new IRDecorations.IRDExpressionType(returnType));
            irInvokeCallMemberNode.attachDecoration(new IRDecorations.IRDFunction(new FunctionTable.LocalFunction(getMethod.getName(), returnType, List.of(), true, false)));
            irDeclarationNode.setExpressionNode(irInvokeCallMemberNode);
        }
    }

    protected void injectNeedsMethods(ScriptScope scriptScope) {
        Location internalLocation = new Location("$internal$ScriptInjectionPhase$injectNeedsMethods", 0);
        for (Method needsMethod : scriptScope.getScriptClassInfo().getNeedsMethods()) {
            Object name = needsMethod.getName();
            name = ((String)name).substring(5);
            name = Character.toLowerCase(((String)name).charAt(0)) + ((String)name).substring(1);
            FunctionNode irFunctionNode = new FunctionNode(internalLocation);
            irFunctionNode.attachDecoration(new IRDecorations.IRDName(needsMethod.getName()));
            irFunctionNode.attachDecoration(new IRDecorations.IRDReturnType(Boolean.TYPE));
            irFunctionNode.attachDecoration(new IRDecorations.IRDTypeParameters(List.of()));
            irFunctionNode.attachDecoration(new IRDecorations.IRDParameterNames(List.of()));
            irFunctionNode.attachCondition(IRDecorations.IRCSynthetic.class);
            irFunctionNode.attachDecoration(new IRDecorations.IRDMaxLoopCounter(0));
            this.irClassNode.addFunctionNode(irFunctionNode);
            BlockNode irBlockNode = new BlockNode(internalLocation);
            irBlockNode.attachCondition(IRDecorations.IRCAllEscape.class);
            irFunctionNode.setBlockNode(irBlockNode);
            ReturnNode irReturnNode = new ReturnNode(internalLocation);
            irBlockNode.addStatementNode(irReturnNode);
            ConstantNode irConstantNode = new ConstantNode(internalLocation);
            irConstantNode.attachDecoration(new IRDecorations.IRDExpressionType(Boolean.TYPE));
            irConstantNode.attachDecoration(new IRDecorations.IRDConstant((Object)scriptScope.getUsedVariables().contains(name)));
            irReturnNode.setExpressionNode(irConstantNode);
        }
    }

    protected void injectSandboxExceptions(FunctionNode irFunctionNode) {
        try {
            Location internalLocation = new Location("$internal$ScriptInjectionPhase$injectSandboxExceptions", 0);
            BlockNode irBlockNode = irFunctionNode.getBlockNode();
            TryNode irTryNode = new TryNode(internalLocation);
            irTryNode.setBlockNode(irBlockNode);
            ThrowNode irThrowNode = PainlessUserTreeToIRTreePhase.createCatchAndThrow(PainlessExplainError.class, internalLocation, irTryNode);
            InvokeCallMemberNode irInvokeCallMemberNode = new InvokeCallMemberNode(internalLocation);
            irInvokeCallMemberNode.attachDecoration(new IRDecorations.IRDExpressionType(ScriptException.class));
            irInvokeCallMemberNode.attachDecoration(new IRDecorations.IRDFunction(new FunctionTable.LocalFunction("convertToScriptException", ScriptException.class, List.of(Throwable.class, Map.class), true, false)));
            irThrowNode.setExpressionNode(irInvokeCallMemberNode);
            LoadVariableNode irLoadVariableNode = new LoadVariableNode(internalLocation);
            irLoadVariableNode.attachDecoration(new IRDecorations.IRDExpressionType(ScriptException.class));
            irLoadVariableNode.attachDecoration(new IRDecorations.IRDName("#painlessExplainError"));
            irInvokeCallMemberNode.addArgumentNode(irLoadVariableNode);
            BinaryImplNode irBinaryImplNode = new BinaryImplNode(internalLocation);
            irBinaryImplNode.attachDecoration(new IRDecorations.IRDExpressionType(Map.class));
            irInvokeCallMemberNode.addArgumentNode(irBinaryImplNode);
            irLoadVariableNode = new LoadVariableNode(internalLocation);
            irLoadVariableNode.attachDecoration(new IRDecorations.IRDExpressionType(PainlessExplainError.class));
            irLoadVariableNode.attachDecoration(new IRDecorations.IRDName("#painlessExplainError"));
            irBinaryImplNode.setLeftNode(irLoadVariableNode);
            InvokeCallNode irInvokeCallNode = new InvokeCallNode(internalLocation);
            irInvokeCallNode.attachDecoration(new IRDecorations.IRDExpressionType(Map.class));
            irInvokeCallNode.setBox(PainlessExplainError.class);
            irInvokeCallNode.setMethod(new PainlessMethod(PainlessExplainError.class.getMethod("getHeaders", PainlessLookup.class), PainlessExplainError.class, null, List.of(), null, null, Map.of()));
            irBinaryImplNode.setRightNode(irInvokeCallNode);
            LoadFieldMemberNode irLoadFieldMemberNode = new LoadFieldMemberNode(internalLocation);
            irLoadFieldMemberNode.attachDecoration(new IRDecorations.IRDExpressionType(PainlessLookup.class));
            irLoadFieldMemberNode.attachDecoration(new IRDecorations.IRDName("$DEFINITION"));
            irLoadFieldMemberNode.attachCondition(IRDecorations.IRCStatic.class);
            irInvokeCallNode.addArgumentNode(irLoadFieldMemberNode);
            irThrowNode = PainlessUserTreeToIRTreePhase.createCatchAndThrow(SecurityException.class, internalLocation, irTryNode);
            irLoadVariableNode = new LoadVariableNode(internalLocation);
            irLoadVariableNode.attachDecoration(new IRDecorations.IRDExpressionType(SecurityException.class));
            irLoadVariableNode.attachDecoration(new IRDecorations.IRDName(PainlessUserTreeToIRTreePhase.getExceptionVariableName(SecurityException.class)));
            irThrowNode.setExpressionNode(irLoadVariableNode);
            for (Class<Exception> throwable : List.of(PainlessError.class, LinkageError.class, OutOfMemoryError.class, StackOverflowError.class, Exception.class)) {
                irThrowNode = PainlessUserTreeToIRTreePhase.createCatchAndThrow(throwable, internalLocation, irTryNode);
                irInvokeCallMemberNode = new InvokeCallMemberNode(internalLocation);
                irInvokeCallMemberNode.attachDecoration(new IRDecorations.IRDExpressionType(ScriptException.class));
                irInvokeCallMemberNode.attachDecoration(new IRDecorations.IRDFunction(new FunctionTable.LocalFunction("convertToScriptException", ScriptException.class, List.of(Throwable.class, Map.class), true, false)));
                irThrowNode.setExpressionNode(irInvokeCallMemberNode);
                irLoadVariableNode = new LoadVariableNode(internalLocation);
                irLoadVariableNode.attachDecoration(new IRDecorations.IRDExpressionType(ScriptException.class));
                irLoadVariableNode.attachDecoration(new IRDecorations.IRDName(PainlessUserTreeToIRTreePhase.getExceptionVariableName(throwable)));
                irInvokeCallMemberNode.addArgumentNode(irLoadVariableNode);
                irBinaryImplNode = new BinaryImplNode(internalLocation);
                irBinaryImplNode.attachDecoration(new IRDecorations.IRDExpressionType(Map.class));
                irInvokeCallMemberNode.addArgumentNode(irBinaryImplNode);
                StaticNode irStaticNode = new StaticNode(internalLocation);
                irStaticNode.attachDecoration(new IRDecorations.IRDExpressionType(Collections.class));
                irBinaryImplNode.setLeftNode(irStaticNode);
                irInvokeCallNode = new InvokeCallNode(internalLocation);
                irInvokeCallNode.attachDecoration(new IRDecorations.IRDExpressionType(Map.class));
                irInvokeCallNode.setBox(Collections.class);
                irInvokeCallNode.setMethod(new PainlessMethod(Collections.class.getMethod("emptyMap", new Class[0]), Collections.class, null, List.of(), null, null, Map.of()));
                irBinaryImplNode.setRightNode(irInvokeCallNode);
            }
            irBlockNode = new BlockNode(internalLocation);
            irBlockNode.attachCondition(IRDecorations.IRCAllEscape.class);
            irBlockNode.addStatementNode(irTryNode);
            irFunctionNode.setBlockNode(irBlockNode);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static String getExceptionVariableName(Class<? extends Throwable> throwable) {
        String name = throwable.getSimpleName();
        return "#" + Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    private static ThrowNode createCatchAndThrow(Class<? extends Throwable> throwable, Location internalLocation, TryNode irTryNode) {
        String name = PainlessUserTreeToIRTreePhase.getExceptionVariableName(throwable);
        CatchNode irCatchNode = new CatchNode(internalLocation);
        irCatchNode.attachDecoration(new IRDecorations.IRDExceptionType(throwable));
        irCatchNode.attachDecoration(new IRDecorations.IRDSymbol(name));
        irTryNode.addCatchNode(irCatchNode);
        BlockNode irCatchBlockNode = new BlockNode(internalLocation);
        irCatchBlockNode.attachCondition(IRDecorations.IRCAllEscape.class);
        irCatchNode.setBlockNode(irCatchBlockNode);
        ThrowNode irThrowNode = new ThrowNode(internalLocation);
        irCatchBlockNode.addStatementNode(irThrowNode);
        return irThrowNode;
    }

    @Override
    public void visitExpression(SExpression userExpressionNode, ScriptScope scriptScope) {
        super.visitExpression(userExpressionNode, scriptScope);
        this.injectConverter(userExpressionNode, scriptScope);
    }

    @Override
    public void visitReturn(SReturn userReturnNode, ScriptScope scriptScope) {
        super.visitReturn(userReturnNode, scriptScope);
        this.injectConverter(userReturnNode, scriptScope);
    }

    public void injectConverter(AStatement userStatementNode, ScriptScope scriptScope) {
        Decorations.Converter converter = scriptScope.getDecoration(userStatementNode, Decorations.Converter.class);
        if (converter == null) {
            return;
        }
        Decorations.IRNodeDecoration irNodeDecoration = scriptScope.getDecoration(userStatementNode, Decorations.IRNodeDecoration.class);
        IRNode irNode = irNodeDecoration.irNode();
        if (!(irNode instanceof ReturnNode)) {
            throw userStatementNode.createError(new IllegalStateException("illegal tree structure"));
        }
        ReturnNode returnNode = (ReturnNode)irNode;
        InvokeCallMemberNode irInvokeCallMemberNode = new InvokeCallMemberNode(userStatementNode.getLocation());
        irInvokeCallMemberNode.attachDecoration(new IRDecorations.IRDFunction(converter.converter()));
        ExpressionNode returnExpression = returnNode.getExpressionNode();
        returnNode.setExpressionNode(irInvokeCallMemberNode);
        irInvokeCallMemberNode.addArgumentNode(returnExpression);
    }

    @Override
    public void visitCallLocal(ECallLocal userCallLocalNode, ScriptScope scriptScope) {
        if ("$".equals(userCallLocalNode.getMethodName())) {
            PainlessMethod thisMethod = scriptScope.getDecoration(userCallLocalNode, Decorations.ThisPainlessMethod.class).thisPainlessMethod();
            InvokeCallMemberNode irInvokeCallMemberNode = new InvokeCallMemberNode(userCallLocalNode.getLocation());
            irInvokeCallMemberNode.attachDecoration(new IRDecorations.IRDThisMethod(thisMethod));
            irInvokeCallMemberNode.addArgumentNode(this.injectCast(userCallLocalNode.getArgumentNodes().get(0), scriptScope));
            irInvokeCallMemberNode.attachDecoration(new IRDecorations.IRDExpressionType(def.class));
            InvokeCallDefNode irCallSubDefNode = new InvokeCallDefNode(userCallLocalNode.getLocation());
            irCallSubDefNode.addArgumentNode(this.injectCast(userCallLocalNode.getArgumentNodes().get(1), scriptScope));
            irCallSubDefNode.attachDecoration(new IRDecorations.IRDExpressionType(def.class));
            irCallSubDefNode.attachDecoration(new IRDecorations.IRDName("get"));
            BinaryImplNode irBinaryImplNode = new BinaryImplNode(userCallLocalNode.getLocation());
            irBinaryImplNode.setLeftNode(irInvokeCallMemberNode);
            irBinaryImplNode.setRightNode(irCallSubDefNode);
            irBinaryImplNode.attachDecoration(new IRDecorations.IRDExpressionType(def.class));
            scriptScope.putDecoration(userCallLocalNode, new Decorations.IRNodeDecoration(irBinaryImplNode));
        } else {
            super.visitCallLocal(userCallLocalNode, scriptScope);
        }
    }
}

