/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.utils.Version;
import org.sonarsource.dotnet.shared.CallableUtils;
import org.sonarsource.dotnet.shared.StringUtils;
import org.sonarsource.dotnet.shared.plugins.AbstractLanguageConfiguration;
import org.sonarsource.dotnet.shared.plugins.RoslynReport;
import org.sonarsource.dotnet.shared.plugins.SarifParserCallbackImpl;
import org.sonarsource.dotnet.shared.sarif.SarifParserFactory;

@ScannerSide
public class RoslynDataImporter {
    private static final Logger LOG = LoggerFactory.getLogger(RoslynDataImporter.class);
    private final AbstractLanguageConfiguration config;

    public RoslynDataImporter(AbstractLanguageConfiguration config) {
        this.config = config;
    }

    public void importRoslynReports(List<RoslynReport> reports, SensorContext context, Map<String, List<RuleKey>> activeRoslynRulesByPartialRepoKey, UnaryOperator<String> toRealPath) {
        Map<String, String> repositoryKeyByRoslynRuleKey = RoslynDataImporter.getRepoKeyByRoslynRuleKey(activeRoslynRulesByPartialRepoKey);
        boolean ignoreThirdPartyIssues = this.config.ignoreThirdPartyIssues() || !context.runtime().getApiVersion().isGreaterThanOrEqual(Version.create((int)7, (int)4));
        SarifParserCallbackImpl callback = new SarifParserCallbackImpl(context, repositoryKeyByRoslynRuleKey, ignoreThirdPartyIssues, this.config.bugCategories(), this.config.codeSmellCategories(), this.config.vulnerabilityCategories());
        LOG.info("Importing {} Roslyn {}", (Object)reports.size(), CallableUtils.lazy(() -> StringUtils.pluralize("report", reports.size())));
        for (RoslynReport report : reports) {
            LOG.debug("Processing Roslyn report: {}", (Object)report.getReportPath());
            SarifParserFactory.create(report, toRealPath).accept(callback);
        }
    }

    private static Map<String, String> getRepoKeyByRoslynRuleKey(Map<String, List<RuleKey>> activeRoslynRulesByPartialRepoKey) {
        HashMap<String, String> repositoryKeyByRoslynRuleKey = new HashMap<String, String>();
        for (List<RuleKey> rules : activeRoslynRulesByPartialRepoKey.values()) {
            for (RuleKey activeRoslynRuleKey : rules) {
                String previousRepositoryKey = repositoryKeyByRoslynRuleKey.put(activeRoslynRuleKey.rule(), activeRoslynRuleKey.repository());
                if (previousRepositoryKey == null) continue;
                throw new IllegalArgumentException("Rule keys must be unique, but \"" + activeRoslynRuleKey.rule() + "\" is defined in both the \"" + previousRepositoryKey + "\" and \"" + activeRoslynRuleKey.repository() + "\" rule repositories.");
            }
        }
        return repositoryKeyByRoslynRuleKey;
    }
}

