/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.dotnet.tests;

import java.io.File;
import java.util.WeakHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.plugins.dotnet.tests.Coverage;
import org.sonar.plugins.dotnet.tests.CoverageParser;

class CoverageCache {
    private static final Logger LOG = LoggerFactory.getLogger(CoverageCache.class);
    private final WeakHashMap<String, Coverage> cache = new WeakHashMap();

    CoverageCache() {
    }

    Coverage readCoverageFromCacheOrParse(CoverageParser parser, File reportFile) {
        String path = reportFile.getAbsolutePath();
        Coverage coverage = this.cache.get(path);
        if (coverage == null) {
            coverage = new Coverage();
            parser.accept(reportFile, coverage);
            this.cache.put(path, coverage);
            LOG.info("Adding this code coverage report to the cache for later reuse: {}", (Object)path);
        } else {
            LOG.info("Successfully retrieved this code coverage report results from the cache: {}", (Object)path);
        }
        return coverage;
    }
}

