/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.dotnet.tests;

import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.plugins.dotnet.tests.FileService;
import org.sonar.plugins.dotnet.tests.PathSuffixPredicate;

@ScannerSide
public class ScannerFileService
implements FileService {
    private static final Logger LOG = LoggerFactory.getLogger(ScannerFileService.class);
    private static final Pattern DETERMINISTIC_SOURCE_PATH_PREFIX = Pattern.compile("^(/_\\d*/)");
    private FileSystem fileSystem;
    private String languageKey;

    public ScannerFileService(String languageKey, FileSystem fileSystem) {
        this.languageKey = languageKey;
        this.fileSystem = fileSystem;
    }

    @Override
    public boolean isSupportedAbsolute(String absolutePath) {
        FilePredicates fp = this.fileSystem.predicates();
        return this.fileSystem.hasFiles(fp.and(fp.hasAbsolutePath(absolutePath), fp.hasLanguage(this.languageKey)));
    }

    @Override
    public Optional<String> getAbsolutePath(String deterministicBuildPath) {
        Matcher matcher = DETERMINISTIC_SOURCE_PATH_PREFIX.matcher(deterministicBuildPath.replace('\\', '/'));
        if (matcher.find()) {
            String pathSuffix = matcher.replaceFirst("");
            FilePredicates fp = this.fileSystem.predicates();
            List foundFiles = StreamSupport.stream(this.fileSystem.inputFiles(fp.and(fp.hasLanguage(this.languageKey), (FilePredicate)new PathSuffixPredicate(pathSuffix))).spliterator(), false).map(x -> x.uri().getPath()).collect(Collectors.toList());
            if (foundFiles.size() == 1) {
                String foundFile = (String)foundFiles.get(0);
                LOG.trace("Found indexed file '{}' for '{}' (normalized to '{}').", new Object[]{foundFile, deterministicBuildPath, pathSuffix});
                return Optional.of(foundFile);
            }
            LOG.debug("Found {} indexed files for '{}' (normalized to '{}'). Will skip this coverage entry. Verify sonar.sources in .sonarqube\\out\\sonar-project.properties.", new Object[]{foundFiles.size(), deterministicBuildPath, pathSuffix});
            return Optional.empty();
        }
        LOG.debug("Did not find deterministic source path in '{}'. Will skip this coverage entry. Verify sonar.sources in .sonarqube\\out\\sonar-project.properties.", (Object)deterministicBuildPath);
        return Optional.empty();
    }
}

