/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.secrets;

import java.util.List;
import org.sonar.api.SonarRuntime;
import org.sonar.plugins.common.CommonRulesDefinition;
import org.sonar.plugins.common.DefaultQualityProfileDefinition;
import org.sonar.plugins.secrets.checks.AlibabaCloudAccessKeyCheck;
import org.sonar.plugins.secrets.checks.AwsCheck;
import org.sonar.plugins.secrets.checks.AzureCheck;
import org.sonar.plugins.secrets.checks.AzureStorageAccountKeyCheck;
import org.sonar.plugins.secrets.checks.ClarifaiCheck;
import org.sonar.plugins.secrets.checks.DjangoCheck;
import org.sonar.plugins.secrets.checks.FacebookCheck;
import org.sonar.plugins.secrets.checks.GenericpublickeycryptographyCheck;
import org.sonar.plugins.secrets.checks.GitHubCheck;
import org.sonar.plugins.secrets.checks.GitLabCheck;
import org.sonar.plugins.secrets.checks.GoogleApiKeyCheck;
import org.sonar.plugins.secrets.checks.GoogleCheck;
import org.sonar.plugins.secrets.checks.GoogleCloudAccountKeyCheck;
import org.sonar.plugins.secrets.checks.GoogleUniqueNameCheck;
import org.sonar.plugins.secrets.checks.IbmApiKeyCheck;
import org.sonar.plugins.secrets.checks.MongoDBCheck;
import org.sonar.plugins.secrets.checks.MwsAuthTokenCheck;
import org.sonar.plugins.secrets.checks.MySQLCheck;
import org.sonar.plugins.secrets.checks.ODBCJDBCConnectionStringCheck;
import org.sonar.plugins.secrets.checks.OpenSSHCheck;
import org.sonar.plugins.secrets.checks.OpenWeatherMapCheck;
import org.sonar.plugins.secrets.checks.PostgreSQLCheck;
import org.sonar.plugins.secrets.checks.RapidAPICheck;
import org.sonar.plugins.secrets.checks.RiotCheck;
import org.sonar.plugins.secrets.checks.SendgridCheck;
import org.sonar.plugins.secrets.checks.SonarQubeCheck;
import org.sonar.plugins.secrets.checks.SpotifyCheck;
import org.sonar.plugins.secrets.checks.TelegramCheck;
import org.sonar.plugins.secrets.checks.WeChatCheck;

public class SecretsRulesDefinition
extends CommonRulesDefinition {
    public static final String REPOSITORY_KEY = "secrets";
    public static final String REPOSITORY_NAME = "Sonar Secrets Analyzer";

    public SecretsRulesDefinition(SonarRuntime sonarRuntime) {
        super(sonarRuntime, REPOSITORY_KEY, REPOSITORY_NAME, REPOSITORY_KEY, SecretsRulesDefinition.checks());
    }

    public static List<Class<?>> checks() {
        return List.of(AlibabaCloudAccessKeyCheck.class, AwsCheck.class, AzureCheck.class, AzureStorageAccountKeyCheck.class, ClarifaiCheck.class, DjangoCheck.class, FacebookCheck.class, GenericpublickeycryptographyCheck.class, GitHubCheck.class, GitLabCheck.class, GoogleApiKeyCheck.class, GoogleCheck.class, GoogleCloudAccountKeyCheck.class, GoogleUniqueNameCheck.class, IbmApiKeyCheck.class, MongoDBCheck.class, MwsAuthTokenCheck.class, MySQLCheck.class, ODBCJDBCConnectionStringCheck.class, OpenSSHCheck.class, OpenWeatherMapCheck.class, PostgreSQLCheck.class, RapidAPICheck.class, RiotCheck.class, SendgridCheck.class, SonarQubeCheck.class, SpotifyCheck.class, TelegramCheck.class, WeChatCheck.class);
    }

    public static class DefaultQualityProfile
    extends DefaultQualityProfileDefinition {
        public DefaultQualityProfile() {
            super(SecretsRulesDefinition.REPOSITORY_KEY, SecretsRulesDefinition.REPOSITORY_KEY);
        }
    }
}

