/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.secrets.api;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import org.sonar.plugins.secrets.api.AuxiliaryPatternMatcher;
import org.sonar.plugins.secrets.api.Match;
import org.sonar.plugins.secrets.api.PatternMatcher;
import org.sonar.plugins.secrets.configuration.model.matching.AuxiliaryPattern;
import org.sonar.plugins.secrets.configuration.model.matching.AuxiliaryPatternType;

public class AuxiliaryMatcher
implements AuxiliaryPatternMatcher {
    private final AuxiliaryPatternType type;
    private final PatternMatcher auxiliaryPatternMatcher;
    private final Integer maxDistance;

    AuxiliaryMatcher(AuxiliaryPatternType type, PatternMatcher auxiliaryPatternMatcher, int maxDistance) {
        this.type = type;
        this.auxiliaryPatternMatcher = auxiliaryPatternMatcher;
        this.maxDistance = maxDistance;
    }

    public static AuxiliaryMatcher build(AuxiliaryPattern auxiliaryPattern) {
        int maxDistance = Integer.MAX_VALUE;
        if (auxiliaryPattern.getMaxCharacterDistance() != null) {
            maxDistance = auxiliaryPattern.getMaxCharacterDistance();
        }
        return new AuxiliaryMatcher(auxiliaryPattern.getType(), PatternMatcher.build(auxiliaryPattern), maxDistance);
    }

    @Override
    public List<Match> filter(List<Match> candidateMatches, String content) {
        if (AuxiliaryPatternType.PATTERN_NOT == this.type) {
            return candidateMatches;
        }
        List<Match> auxiliaryMatches = this.auxiliaryPatternMatcher.findIn(content);
        if (auxiliaryMatches.isEmpty()) {
            return new ArrayList<Match>();
        }
        BiPredicate<Match, Match> comparisonFunction = this.createComparisonFunction();
        return AuxiliaryMatcher.filterBasedOnFunction(candidateMatches, auxiliaryMatches, comparisonFunction);
    }

    private BiPredicate<Match, Match> createComparisonFunction() {
        BiPredicate<Match, Match> result = AuxiliaryPatternType.PATTERN_BEFORE == this.type ? Match::isBefore : (AuxiliaryPatternType.PATTERN_AFTER == this.type ? Match::isAfter : (auxMatch, candidateMatch) -> auxMatch.isBefore((Match)candidateMatch) || auxMatch.isAfter((Match)candidateMatch));
        if (this.maxDistance != Integer.MAX_VALUE) {
            result = result.and((? super T auxMatch, ? super U candidateMatch) -> auxMatch.inDistanceOf((Match)candidateMatch, this.maxDistance));
        }
        return result;
    }

    private static List<Match> filterBasedOnFunction(List<Match> candidateMatches, List<Match> auxiliaryMatches, BiPredicate<Match, Match> comparisonFunction) {
        ArrayList<Match> filteredCandidates = new ArrayList<Match>();
        block0: for (Match regexMatch : candidateMatches) {
            for (Match auxiliaryMatch : auxiliaryMatches) {
                if (!comparisonFunction.test(auxiliaryMatch, regexMatch)) continue;
                filteredCandidates.add(regexMatch);
                continue block0;
            }
        }
        return filteredCandidates;
    }
}

