/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.secrets.api;

import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.plugins.secrets.api.EntropyChecker;
import org.sonar.plugins.secrets.api.Heuristics;
import org.sonar.plugins.secrets.configuration.model.matching.Matching;
import org.sonar.plugins.secrets.configuration.model.matching.filter.HeuristicsFilter;
import org.sonar.plugins.secrets.configuration.model.matching.filter.PostModule;
import org.sonar.plugins.secrets.configuration.model.matching.filter.StatisticalFilter;

public class PostFilterFactory {
    private PostFilterFactory() {
    }

    public static Predicate<String> createPredicate(@Nullable PostModule post, @Nullable Matching matching) {
        Predicate<String> postFilter = s -> true;
        if (post != null) {
            if (post.getStatisticalFilter() != null) {
                postFilter = postFilter.and(PostFilterFactory.filterForStatisticalFilter(post.getStatisticalFilter(), matching));
            }
            if (post.getPatternNot() != null) {
                postFilter = postFilter.and(PostFilterFactory.filterForPatternNot(post.getPatternNot()));
            }
            if (post.getHeuristicFilter() != null) {
                postFilter = postFilter.and(PostFilterFactory.filterForHeuristicsFilter(post.getHeuristicFilter()));
            }
        }
        return postFilter;
    }

    static Predicate<String> filterForPatternNot(String patternNot) {
        return candidateSecret -> {
            Matcher matcher = Pattern.compile(patternNot).matcher((CharSequence)candidateSecret);
            return !matcher.find();
        };
    }

    static Predicate<String> filterForStatisticalFilter(StatisticalFilter statisticalFilter, @Nullable Matching matching) {
        return candidateSecret -> {
            String entropyInputString = candidateSecret;
            if (statisticalFilter.getInputString() != null && matching != null) {
                entropyInputString = PostFilterFactory.calculateEntropyInputBasedOnNamedGroup(statisticalFilter.getInputString(), candidateSecret, matching);
            }
            return !EntropyChecker.hasLowEntropy(entropyInputString, statisticalFilter.getThreshold());
        };
    }

    static String calculateEntropyInputBasedOnNamedGroup(String groupName, String candidateSecret, Matching matching) {
        Matcher matcher = Pattern.compile(matching.getPattern()).matcher(candidateSecret);
        if (matcher.find()) {
            try {
                return matcher.group(groupName);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return candidateSecret;
    }

    static Predicate<String> filterForHeuristicsFilter(HeuristicsFilter heuristicFilter) {
        return candidateSecret -> !Heuristics.matchesHeuristics(candidateSecret, heuristicFilter.getHeuristics());
    }
}

