/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.secrets.api;

import java.util.List;
import java.util.Locale;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.plugins.common.InputFileContext;
import org.sonar.plugins.secrets.configuration.model.matching.filter.FileFilter;
import org.sonar.plugins.secrets.configuration.model.matching.filter.PreModule;

public class PreFilterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PreFilterFactory.class);
    private static final Predicate<InputFileContext> INCLUDE_ALL_FILES = ctx -> true;

    private PreFilterFactory() {
    }

    public static Predicate<InputFileContext> createPredicate(@Nullable PreModule pre) {
        if (pre == null) {
            return INCLUDE_ALL_FILES;
        }
        Predicate<InputFileContext> predicate = INCLUDE_ALL_FILES;
        FileFilter include = pre.getInclude();
        FileFilter reject = pre.getReject();
        if (reject != null) {
            predicate = predicate.and(Predicate.not(ctx -> PreFilterFactory.matches(reject, ctx)));
        }
        if (include != null) {
            predicate = predicate.and(ctx -> PreFilterFactory.matches(include, ctx));
        }
        return predicate;
    }

    private static boolean matches(FileFilter filter, InputFileContext ctx) {
        return PreFilterFactory.anyMatch(filter.getPaths(), PreFilterFactory::matchesPath, ctx) || PreFilterFactory.anyMatch(filter.getExt(), PreFilterFactory::matchesExt, ctx) || PreFilterFactory.anyMatch(filter.getContent(), PreFilterFactory::matchesContent, ctx);
    }

    private static boolean anyMatch(@Nullable List<String> filterElements, BiPredicate<String, InputFileContext> filterFunction, InputFileContext ctx) {
        if (filterElements == null) {
            return false;
        }
        return filterElements.stream().anyMatch(filterElement -> filterFunction.test((String)filterElement, ctx));
    }

    static boolean matchesPath(String path, InputFileContext ctx) {
        if (path.isBlank()) {
            LOG.warn("Parameter <paths> is blank in pre filter, will skip filtering");
            return false;
        }
        if (path.contains("*")) {
            return ctx.getFileSystem().predicates().matchesPathPattern(path).apply(ctx.getInputFile());
        }
        return ctx.getFileSystem().predicates().hasRelativePath(path).apply(ctx.getInputFile());
    }

    static boolean matchesContent(String content, InputFileContext ctx) {
        if (content.isBlank()) {
            LOG.warn("Parameter <content> is blank in pre filter, will skip filtering");
            return false;
        }
        String contentLowerCase = content.toLowerCase(Locale.getDefault());
        return ctx.lines().stream().anyMatch(line -> line.toLowerCase(Locale.getDefault()).contains(contentLowerCase));
    }

    static boolean matchesExt(String ext, InputFileContext ctx) {
        if (ext.isBlank()) {
            LOG.warn("Parameter <ext> is blank in pre filter, will skip filtering");
            return false;
        }
        String extWithoutDot = ext.startsWith(".") ? ext.substring(ext.lastIndexOf(".") + 1) : ext;
        return ctx.getFileSystem().predicates().hasExtension(extWithoutDot).apply(ctx.getInputFile());
    }
}

