/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.secrets.api;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.sonar.plugins.common.InputFileContext;
import org.sonar.plugins.secrets.api.AuxiliaryPatternMatcher;
import org.sonar.plugins.secrets.api.AuxiliaryPatternMatcherFactory;
import org.sonar.plugins.secrets.api.Match;
import org.sonar.plugins.secrets.api.PatternMatcher;
import org.sonar.plugins.secrets.api.PostFilterFactory;
import org.sonar.plugins.secrets.api.PreFilterFactory;
import org.sonar.plugins.secrets.configuration.model.Rule;

public class SecretMatcher {
    private final Rule rule;
    private final PatternMatcher patternMatcher;
    private final AuxiliaryPatternMatcher auxiliaryPatternMatcher;
    private final Predicate<InputFileContext> preFilter;
    private final Predicate<String> postFilter;

    SecretMatcher(Rule rule, PatternMatcher patternMatcher, AuxiliaryPatternMatcher auxiliaryPatternMatcher, Predicate<InputFileContext> preFilter, Predicate<String> postFilter) {
        this.rule = rule;
        this.patternMatcher = patternMatcher;
        this.auxiliaryPatternMatcher = auxiliaryPatternMatcher;
        this.preFilter = preFilter;
        this.postFilter = postFilter;
    }

    public static SecretMatcher build(Rule rule) {
        PatternMatcher patternMatcher = PatternMatcher.build(rule.getDetection().getMatching());
        Predicate<InputFileContext> preFilter = PreFilterFactory.createPredicate(rule.getDetection().getPre());
        Predicate<String> postFilter = PostFilterFactory.createPredicate(rule.getDetection().getPost(), rule.getDetection().getMatching());
        AuxiliaryPatternMatcher auxiliaryMatcher = AuxiliaryPatternMatcherFactory.build(rule.getDetection().getMatching());
        return new SecretMatcher(rule, patternMatcher, auxiliaryMatcher, preFilter, postFilter);
    }

    public List<Match> findIn(InputFileContext fileContext) {
        if (!this.preFilter.test(fileContext)) {
            return Collections.emptyList();
        }
        String content = fileContext.content();
        List<Match> candidateSecrets = this.patternMatcher.findIn(content);
        List<Match> secretsFilteredOnContext = this.auxiliaryPatternMatcher.filter(candidateSecrets, content);
        return secretsFilteredOnContext.stream().filter(match -> this.postFilter.test(match.getText())).collect(Collectors.toList());
    }

    public String getMessageFromRule() {
        return this.rule.getMetadata().getMessage();
    }

    Predicate<String> getPostFilter() {
        return this.postFilter;
    }

    AuxiliaryPatternMatcher getAuxiliaryPatternMatcher() {
        return this.auxiliaryPatternMatcher;
    }
}

