/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.secrets.configuration.deserialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.sonar.plugins.secrets.configuration.model.matching.AuxiliaryPattern;
import org.sonar.plugins.secrets.configuration.model.matching.AuxiliaryPatternType;

public class AuxiliaryPatternDeserializer
extends JsonDeserializer<AuxiliaryPattern> {
    @Override
    public AuxiliaryPattern deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        Object treeNode = jsonParser.getCodec().readTree(jsonParser);
        Iterator<Map.Entry<String, JsonNode>> fields = ((ObjectNode)treeNode).fields();
        Map.Entry<String, JsonNode> node = fields.next();
        AuxiliaryPattern auxiliaryPattern = new AuxiliaryPattern();
        auxiliaryPattern.setType(AuxiliaryPatternType.valueOfLabel(node.getKey()));
        if (node.getValue() instanceof TextNode) {
            auxiliaryPattern.setPattern(node.getValue().asText());
        } else {
            auxiliaryPattern.setPattern(node.getValue().get("pattern").asText());
            auxiliaryPattern.setMaxCharacterDistance(node.getValue().get("maxDistance").asInt());
        }
        return auxiliaryPattern;
    }
}

