/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.secrets.configuration.deserialization;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.InputStream;
import org.sonar.plugins.secrets.configuration.deserialization.DeserializationException;
import org.sonar.plugins.secrets.configuration.model.Specification;

public class SpecificationDeserializer {
    private static final ObjectMapper MAPPER = new ObjectMapper(new YAMLFactory());

    private SpecificationDeserializer() {
    }

    public static Specification deserialize(InputStream specificationStream, String fileName) {
        try {
            JsonNode specification = MAPPER.readTree(specificationStream);
            return MAPPER.treeToValue((TreeNode)specification, Specification.class);
        }
        catch (IOException e) {
            throw new DeserializationException(String.format("Deserialization of specification failed for file: %s", fileName), e);
        }
        catch (IllegalArgumentException e) {
            throw new DeserializationException(String.format("Deserialization of specification failed for file because it was not found: %s", fileName), e);
        }
    }
}

