/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexKeyword;

@Rule(key="S1466")
public class ExactSettingsSetToFalseCheck
extends FlexCheck {
    private static final State[][] TRANSITIONS = new State[State.values().length][Symbol.values().length];
    private State currentState;

    @Override
    public List<AstNodeType> subscribedTo() {
        return Collections.emptyList();
    }

    @Override
    public void visitFile(@Nullable AstNode node) {
        this.currentState = State.EXPECTING_SECURITY;
    }

    @Override
    public void visitToken(Token token) {
        this.currentState = TRANSITIONS[this.currentState.ordinal()][ExactSettingsSetToFalseCheck.getSymbol(token.getOriginalValue()).ordinal()];
        if (this.currentState == State.FOUND_ISSUE) {
            this.addIssue("Set flash.system.Security.exactSettings to true", token);
            this.currentState = State.EXPECTING_SECURITY;
        }
    }

    private static Symbol getSymbol(String value) {
        Symbol result = Symbol.OTHER;
        if (".".equals(value)) {
            result = Symbol.DOT;
        } else if ("Security".equals(value)) {
            result = Symbol.SECURITY;
        } else if ("exactSettings".equals(value)) {
            result = Symbol.EXACT_SETTINGS;
        } else if ("=".equals(value)) {
            result = Symbol.EQUAL;
        } else if (FlexKeyword.FALSE.getValue().equals(value)) {
            result = Symbol.FALSE;
        }
        return result;
    }

    static {
        for (int i = 0; i < TRANSITIONS.length; ++i) {
            for (int j = 0; j < TRANSITIONS[i].length; ++j) {
                ExactSettingsSetToFalseCheck.TRANSITIONS[i][j] = State.EXPECTING_SECURITY;
            }
        }
        ExactSettingsSetToFalseCheck.TRANSITIONS[State.EXPECTING_SECURITY.ordinal()][Symbol.SECURITY.ordinal()] = State.EXPECTING_DOT;
        ExactSettingsSetToFalseCheck.TRANSITIONS[State.EXPECTING_DOT.ordinal()][Symbol.DOT.ordinal()] = State.EXPECTING_EXACT_SETTINGS;
        ExactSettingsSetToFalseCheck.TRANSITIONS[State.EXPECTING_EXACT_SETTINGS.ordinal()][Symbol.EXACT_SETTINGS.ordinal()] = State.EXPECTING_EQUAL;
        ExactSettingsSetToFalseCheck.TRANSITIONS[State.EXPECTING_EQUAL.ordinal()][Symbol.EQUAL.ordinal()] = State.EXPECTING_FALSE;
        ExactSettingsSetToFalseCheck.TRANSITIONS[State.EXPECTING_FALSE.ordinal()][Symbol.FALSE.ordinal()] = State.FOUND_ISSUE;
    }

    private static enum State {
        EXPECTING_SECURITY,
        EXPECTING_DOT,
        EXPECTING_EXACT_SETTINGS,
        EXPECTING_EQUAL,
        EXPECTING_FALSE,
        FOUND_ISSUE;

    }

    private static enum Symbol {
        OTHER,
        SECURITY,
        DOT,
        EXACT_SETTINGS,
        EQUAL,
        FALSE;

    }
}

