/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.checks.utils.Expression;

@Rule(key="S1982")
public class OnEnterFrameUseCheck
extends FlexCheck {
    @Override
    public List<AstNodeType> subscribedTo() {
        return Collections.singletonList(FlexGrammar.ASSIGNMENT_EXPR);
    }

    @Override
    public void visitNode(AstNode astNode) {
        if (astNode.getNumberOfChildren() > 1 && OnEnterFrameUseCheck.isOnEnterFrame(astNode.getFirstChild()) && OnEnterFrameUseCheck.isFunctionExpr(astNode.getLastChild())) {
            this.addIssue("Refactor this code to remove the use of \"onEnterFrame\" event handler.", astNode);
        }
    }

    private static boolean isFunctionExpr(AstNode assignementExpr) {
        AstNode assignmentExprChild = assignementExpr.getFirstChild();
        return assignmentExprChild.is(FlexGrammar.POSTFIX_EXPR) && assignmentExprChild.getFirstChild().getFirstChild().is(FlexGrammar.FUNCTION_EXPR);
    }

    private static boolean isOnEnterFrame(AstNode postfixExpr) {
        return Expression.exprToString(postfixExpr).endsWith(".onEnterFrame");
    }
}

