/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.server.cli;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.elasticsearch.bootstrap.ServerArgs;
import org.elasticsearch.cli.ProcessInfo;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.io.stream.OutputStreamStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.PathUtils;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.server.cli.ErrorPumpThread;
import org.elasticsearch.server.cli.JvmOptionsParser;
import org.elasticsearch.server.cli.ProcessUtil;

public class ServerProcess {
    private final Process jvmProcess;
    private final ErrorPumpThread errorPump;
    private volatile boolean detached = false;

    ServerProcess(Process jvmProcess, ErrorPumpThread errorPump) {
        this.jvmProcess = jvmProcess;
        this.errorPump = errorPump;
    }

    public static ServerProcess start(Terminal terminal, ProcessInfo processInfo, ServerArgs args) throws UserException {
        return ServerProcess.start(terminal, processInfo, args, JvmOptionsParser::determineJvmOptions, ProcessBuilder::start);
    }

    static ServerProcess start(Terminal terminal, ProcessInfo processInfo, ServerArgs args, OptionsBuilder optionsBuilder, ProcessStarter processStarter) throws UserException {
        ErrorPumpThread errorPump;
        Process jvmProcess = null;
        boolean success = false;
        try {
            jvmProcess = ServerProcess.createProcess(args, processInfo, args.configDir(), optionsBuilder, processStarter);
            errorPump = new ErrorPumpThread(terminal.getErrorWriter(), jvmProcess.getErrorStream());
            errorPump.start();
            ServerProcess.sendArgs(args, jvmProcess.getOutputStream());
            String errorMsg = errorPump.waitUntilReady();
            if (errorMsg != null) {
                int exitCode = jvmProcess.waitFor();
                throw new UserException(exitCode, errorMsg);
            }
            success = true;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (!success && jvmProcess != null && jvmProcess.isAlive()) {
                jvmProcess.destroyForcibly();
            }
        }
        return new ServerProcess(jvmProcess, errorPump);
    }

    public long pid() {
        return this.jvmProcess.pid();
    }

    public synchronized void detach() throws IOException {
        this.errorPump.drain();
        IOUtils.close((Closeable[])new Closeable[]{this.jvmProcess.getOutputStream(), this.jvmProcess.getInputStream(), this.jvmProcess.getErrorStream()});
        this.detached = true;
    }

    public int waitFor() {
        this.errorPump.drain();
        return ProcessUtil.nonInterruptible(this.jvmProcess::waitFor);
    }

    public synchronized void stop() {
        if (this.detached) {
            return;
        }
        this.sendShutdownMarker();
        this.waitFor();
    }

    private static void sendArgs(ServerArgs args, OutputStream processStdin) {
        OutputStreamStreamOutput out = new OutputStreamStreamOutput(processStdin);
        try {
            args.writeTo((StreamOutput)out);
            out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendShutdownMarker() {
        try {
            OutputStream os = this.jvmProcess.getOutputStream();
            os.write(27);
            os.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Process createProcess(ServerArgs args, ProcessInfo processInfo, Path configDir, OptionsBuilder optionsBuilder, ProcessStarter processStarter) throws InterruptedException, IOException, UserException {
        HashMap<String, String> envVars = new HashMap<String, String>(processInfo.envVars());
        Path tempDir = ServerProcess.setupTempDir(processInfo, (String)envVars.remove("ES_TMPDIR"));
        if (!envVars.containsKey("LIBFFI_TMPDIR")) {
            envVars.put("LIBFFI_TMPDIR", tempDir.toString());
        }
        List<String> jvmOptions = optionsBuilder.getJvmOptions(args, configDir, tempDir, (String)envVars.remove("ES_JAVA_OPTS"));
        jvmOptions.add("-Des.distribution.type=" + (String)processInfo.sysprops().get("es.distribution.type"));
        Path esHome = processInfo.workingDir();
        Path javaHome = PathUtils.get((String)((String)processInfo.sysprops().get("java.home")), (String[])new String[0]);
        ArrayList<String> command = new ArrayList<String>();
        boolean isWindows = ((String)processInfo.sysprops().get("os.name")).startsWith("Windows");
        command.add(javaHome.resolve("bin").resolve("java" + (isWindows ? ".exe" : "")).toString());
        command.addAll(jvmOptions);
        command.add("--module-path");
        command.add(esHome.resolve("lib").toString());
        command.add("--add-modules=jdk.net");
        command.add("-m");
        command.add("org.elasticsearch.server/org.elasticsearch.bootstrap.Elasticsearch");
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.environment().putAll(envVars);
        builder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        return processStarter.start(builder);
    }

    private static Path setupTempDir(ProcessInfo processInfo, String tmpDirOverride) throws UserException, IOException {
        Path path;
        if (tmpDirOverride != null) {
            path = Paths.get(tmpDirOverride, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                throw new UserException(78, "Temporary directory [" + path + "] does not exist or is not accessible");
            }
            if (!Files.isDirectory(path, new LinkOption[0])) {
                throw new UserException(78, "Temporary directory [" + path + "] is not a directory");
            }
        } else if (((String)processInfo.sysprops().get("os.name")).startsWith("Windows")) {
            path = Paths.get((String)processInfo.sysprops().get("java.io.tmpdir"), "elasticsearch");
            Files.createDirectories(path, new FileAttribute[0]);
        } else {
            path = ServerProcess.createTempDirectory("elasticsearch-", new FileAttribute[0]);
        }
        return path;
    }

    @SuppressForbidden(reason="Files#createTempDirectory(String, FileAttribute...)")
    private static Path createTempDirectory(String prefix, FileAttribute<?> ... attrs) throws IOException {
        return Files.createTempDirectory(prefix, attrs);
    }

    static interface OptionsBuilder {
        public List<String> getJvmOptions(ServerArgs var1, Path var2, Path var3, String var4) throws InterruptedException, IOException, UserException;
    }

    static interface ProcessStarter {
        public Process start(ProcessBuilder var1) throws IOException;
    }
}

