/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.transport;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.ssl.SslConfiguration;
import org.elasticsearch.transport.RemoteClusterPortSettings;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.ssl.SSLService;

public final class ProfileConfigurations {
    private ProfileConfigurations() {
    }

    public static Map<String, SslConfiguration> get(Settings settings, SSLService sslService, boolean sslEnabledOnly) {
        boolean transportSslEnabled = (Boolean)XPackSettings.TRANSPORT_SSL_ENABLED.get(settings);
        boolean remoteClusterPortEnabled = (Boolean)RemoteClusterPortSettings.REMOTE_CLUSTER_PORT_ENABLED.get(settings);
        boolean remoteClusterSslEnabled = remoteClusterPortEnabled && (Boolean)XPackSettings.REMOTE_CLUSTER_SSL_ENABLED.get(settings) != false;
        HashMap<String, SslConfiguration> profileConfigurations = new HashMap<String, SslConfiguration>();
        if (sslEnabledOnly) {
            if (!transportSslEnabled && !remoteClusterSslEnabled) {
                return profileConfigurations;
            }
            if (!transportSslEnabled) {
                profileConfigurations.put("_remote_cluster", sslService.getSSLConfiguration(XPackSettings.REMOTE_CLUSTER_SSL_PREFIX));
                return profileConfigurations;
            }
            if (!remoteClusterSslEnabled) {
                ProfileConfigurations.populateFromTransportProfiles(settings, sslService, profileConfigurations);
                return profileConfigurations;
            }
        }
        ProfileConfigurations.populateFromTransportProfiles(settings, sslService, profileConfigurations);
        if (remoteClusterPortEnabled) {
            assert (!profileConfigurations.containsKey("_remote_cluster"));
            profileConfigurations.put("_remote_cluster", sslService.getSSLConfiguration(XPackSettings.REMOTE_CLUSTER_SSL_PREFIX));
        }
        return profileConfigurations;
    }

    private static void populateFromTransportProfiles(Settings settings, SSLService sslService, Map<String, SslConfiguration> profileConfigurations) {
        SslConfiguration defaultConfiguration = sslService.getSSLConfiguration(SecurityField.setting((String)"transport.ssl."));
        Set profileNames = settings.getGroups("transport.profiles.", true).keySet();
        for (String profileName : profileNames) {
            if (profileName.equals("default")) {
                if (settings.getByPrefix("transport.profiles.default.xpack.security.ssl.").isEmpty()) continue;
                throw new IllegalArgumentException("SSL settings should not be configured for the default profile. Use the [xpack.security.transport.ssl] settings instead.");
            }
            SslConfiguration configuration = sslService.getSSLConfiguration("transport.profiles." + profileName + "." + SecurityField.setting((String)"ssl"));
            profileConfigurations.put(profileName, configuration);
        }
        assert (!profileConfigurations.containsKey("default"));
        profileConfigurations.put("default", defaultConfiguration);
    }
}

