/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.transport.netty4;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.Map;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.ssl.SslConfiguration;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.RemoteClusterPortSettings;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.netty4.Netty4Transport;
import org.elasticsearch.transport.netty4.SharedGroupFactory;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.transport.ProfileConfigurations;
import org.elasticsearch.xpack.core.security.transport.SecurityTransportExceptionHandler;
import org.elasticsearch.xpack.core.ssl.SSLService;

public class SecurityNetty4Transport
extends Netty4Transport {
    private static final Logger logger = LogManager.getLogger(SecurityNetty4Transport.class);
    private final SecurityTransportExceptionHandler exceptionHandler;
    private final SSLService sslService;
    private final SslConfiguration defaultSslConfiguration;
    private final Map<String, SslConfiguration> profileConfigurations;
    private final boolean transportSslEnabled;
    private final boolean remoteClusterPortEnabled;
    private final boolean remoteClusterSslEnabled;
    private final SslConfiguration remoteClusterClientSslConfiguration;

    public SecurityNetty4Transport(Settings settings, TransportVersion version, ThreadPool threadPool, NetworkService networkService, PageCacheRecycler pageCacheRecycler, NamedWriteableRegistry namedWriteableRegistry, CircuitBreakerService circuitBreakerService, SSLService sslService, SharedGroupFactory sharedGroupFactory) {
        super(settings, version, threadPool, networkService, pageCacheRecycler, namedWriteableRegistry, circuitBreakerService, sharedGroupFactory);
        this.exceptionHandler = new SecurityTransportExceptionHandler(logger, this.lifecycle, (c, e) -> super.onException(c, e));
        this.sslService = sslService;
        this.transportSslEnabled = (Boolean)XPackSettings.TRANSPORT_SSL_ENABLED.get(settings);
        this.remoteClusterPortEnabled = (Boolean)RemoteClusterPortSettings.REMOTE_CLUSTER_PORT_ENABLED.get(settings);
        this.remoteClusterSslEnabled = (Boolean)XPackSettings.REMOTE_CLUSTER_SSL_ENABLED.get(settings);
        this.profileConfigurations = Collections.unmodifiableMap(ProfileConfigurations.get(settings, sslService, true));
        this.defaultSslConfiguration = this.profileConfigurations.get("default");
        assert (!this.transportSslEnabled || this.defaultSslConfiguration != null);
        if (this.remoteClusterSslEnabled) {
            this.remoteClusterClientSslConfiguration = sslService.getSSLConfiguration(XPackSettings.REMOTE_CLUSTER_SSL_PREFIX);
            assert (this.remoteClusterClientSslConfiguration != null);
        } else {
            this.remoteClusterClientSslConfiguration = null;
        }
    }

    protected void doStart() {
        super.doStart();
    }

    public final ChannelHandler getServerChannelInitializer(String name) {
        if (this.remoteClusterPortEnabled && "_remote_cluster".equals(name)) {
            if (this.remoteClusterSslEnabled) {
                SslConfiguration remoteClusterSslConfiguration = this.profileConfigurations.get(name);
                if (remoteClusterSslConfiguration == null) {
                    throw new IllegalStateException("remote cluster SSL is enabled but no configuration is found");
                }
                return this.getSslChannelInitializer(name, remoteClusterSslConfiguration);
            }
            return this.getNoSslChannelInitializer(name);
        }
        if (this.transportSslEnabled) {
            SslConfiguration configuration = this.profileConfigurations.get(name);
            if (configuration == null) {
                throw new IllegalStateException("unknown profile: " + name);
            }
            return this.getSslChannelInitializer(name, configuration);
        }
        return this.getNoSslChannelInitializer(name);
    }

    protected ChannelHandler getNoSslChannelInitializer(String name) {
        return super.getServerChannelInitializer(name);
    }

    protected ChannelHandler getClientChannelInitializer(DiscoveryNode node, ConnectionProfile connectionProfile) {
        return new SecurityClientChannelInitializer(node, connectionProfile);
    }

    public void onException(TcpChannel channel, Exception e) {
        this.exceptionHandler.accept(channel, e);
    }

    protected Netty4Transport.ServerChannelInitializer getSslChannelInitializer(String name, SslConfiguration configuration) {
        return new SslChannelInitializer(name, configuration);
    }

    public boolean isSecure() {
        return this.transportSslEnabled;
    }

    private class SecurityClientChannelInitializer
    extends Netty4Transport.ClientChannelInitializer {
        private final boolean hostnameVerificationEnabled;
        private final SNIHostName serverName;
        private final SslConfiguration channelSslConfiguration;

        SecurityClientChannelInitializer(DiscoveryNode node, ConnectionProfile connectionProfile) {
            super((Netty4Transport)SecurityNetty4Transport.this);
            String transportProfile = connectionProfile.getTransportProfile();
            logger.trace("initiating security client channel with transport profile [{}]", (Object)transportProfile);
            if ("_remote_cluster".equals(transportProfile)) {
                this.channelSslConfiguration = SecurityNetty4Transport.this.remoteClusterClientSslConfiguration;
            } else {
                assert ("default".equals(transportProfile));
                this.channelSslConfiguration = SecurityNetty4Transport.this.defaultSslConfiguration;
            }
            this.hostnameVerificationEnabled = this.channelSslConfiguration != null ? this.channelSslConfiguration.verificationMode().isHostnameVerificationEnabled() : false;
            String configuredServerName = (String)node.getAttributes().get("server_name");
            if (configuredServerName != null) {
                try {
                    this.serverName = new SNIHostName(configuredServerName);
                }
                catch (IllegalArgumentException e) {
                    throw new ConnectTransportException(node, "invalid DiscoveryNode server_name [" + configuredServerName + "]", (Throwable)e);
                }
            } else {
                this.serverName = null;
            }
        }

        protected void initChannel(Channel ch) throws Exception {
            super.initChannel(ch);
            if (this.channelSslConfiguration != null) {
                ch.pipeline().addFirst(new ChannelHandler[]{new ClientSslHandlerInitializer(this.channelSslConfiguration, SecurityNetty4Transport.this.sslService, this.hostnameVerificationEnabled, this.serverName)});
            }
        }
    }

    public class SslChannelInitializer
    extends Netty4Transport.ServerChannelInitializer {
        private final SslConfiguration configuration;

        public SslChannelInitializer(String name, SslConfiguration configuration) {
            super((Netty4Transport)SecurityNetty4Transport.this, name);
            this.configuration = configuration;
        }

        protected void initChannel(Channel ch) throws Exception {
            SSLEngine serverEngine = SecurityNetty4Transport.this.sslService.createSSLEngine(this.configuration, null, -1);
            serverEngine.setUseClientMode(false);
            SslHandler sslHandler = new SslHandler(serverEngine);
            ch.pipeline().addFirst("sslhandler", (ChannelHandler)sslHandler);
            super.initChannel(ch);
            assert (ch.pipeline().first() == sslHandler) : "SSL handler must be first handler in pipeline";
        }
    }

    private static class ClientSslHandlerInitializer
    extends ChannelOutboundHandlerAdapter {
        private final boolean hostnameVerificationEnabled;
        private final SslConfiguration sslConfiguration;
        private final SSLService sslService;
        private final SNIServerName serverName;

        private ClientSslHandlerInitializer(SslConfiguration sslConfiguration, SSLService sslService, boolean hostnameVerificationEnabled, SNIServerName serverName) {
            this.sslConfiguration = sslConfiguration;
            this.hostnameVerificationEnabled = hostnameVerificationEnabled;
            this.sslService = sslService;
            this.serverName = serverName;
        }

        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            SSLEngine sslEngine;
            if (this.hostnameVerificationEnabled) {
                InetSocketAddress inetSocketAddress = (InetSocketAddress)remoteAddress;
                sslEngine = this.sslService.createSSLEngine(this.sslConfiguration, inetSocketAddress.getHostString(), inetSocketAddress.getPort());
            } else {
                sslEngine = this.sslService.createSSLEngine(this.sslConfiguration, null, -1);
            }
            sslEngine.setUseClientMode(true);
            if (this.serverName != null) {
                SSLParameters sslParameters = sslEngine.getSSLParameters();
                sslParameters.setServerNames(Collections.singletonList(this.serverName));
                sslEngine.setSSLParameters(sslParameters);
            }
            ChannelPromise connectPromise = ctx.newPromise();
            SslHandler sslHandler = new SslHandler(sslEngine);
            ctx.pipeline().replace((ChannelHandler)this, "ssl", (ChannelHandler)sslHandler);
            Future handshakePromise = sslHandler.handshakeFuture();
            connectPromise.addListener(result -> {
                if (!result.isSuccess()) {
                    promise.tryFailure(result.cause());
                } else {
                    handshakePromise.addListener(handshakeResult -> {
                        if (handshakeResult.isSuccess()) {
                            promise.setSuccess();
                        } else {
                            promise.tryFailure(handshakeResult.cause());
                        }
                    });
                }
            });
            super.connect(ctx, remoteAddress, localAddress, connectPromise);
        }
    }
}

