/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.apikey;

import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.apikey.BaseUpdateApiKeyRequest;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.security.authc.support.ApiKeyUserRoleDescriptorResolver;
import org.elasticsearch.xpack.security.authz.store.CompositeRolesStore;

public abstract class TransportBaseUpdateApiKeyAction<Request extends BaseUpdateApiKeyRequest, Response extends ActionResponse>
extends HandledTransportAction<Request, Response> {
    private final SecurityContext securityContext;
    private final ApiKeyUserRoleDescriptorResolver resolver;

    protected TransportBaseUpdateApiKeyAction(String actionName, TransportService transportService, ActionFilters actionFilters, Writeable.Reader<Request> requestReader, SecurityContext context, CompositeRolesStore rolesStore, NamedXContentRegistry xContentRegistry) {
        super(actionName, transportService, actionFilters, requestReader);
        this.securityContext = context;
        this.resolver = new ApiKeyUserRoleDescriptorResolver(rolesStore, xContentRegistry);
    }

    public final void doExecute(Task task, Request request, ActionListener<Response> listener) {
        Authentication authentication = this.securityContext.getAuthentication();
        if (authentication == null) {
            listener.onFailure((Exception)new IllegalStateException("authentication is required"));
            return;
        }
        if (authentication.isApiKey()) {
            listener.onFailure((Exception)new IllegalArgumentException("authentication via API key not supported: only the owner user can update an API key"));
            return;
        }
        this.resolver.resolveUserRoleDescriptors(authentication, (ActionListener<Set<RoleDescriptor>>)ActionListener.wrap(roleDescriptors -> this.doExecuteUpdate(task, request, authentication, (Set<RoleDescriptor>)roleDescriptors, listener), arg_0 -> listener.onFailure(arg_0)));
    }

    abstract void doExecuteUpdate(Task var1, Request var2, Authentication var3, Set<RoleDescriptor> var4, ActionListener<Response> var5);
}

