/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.apikey;

import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.apikey.BulkUpdateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.BulkUpdateApiKeyResponse;
import org.elasticsearch.xpack.core.security.action.apikey.UpdateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.UpdateApiKeyResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.security.action.apikey.TransportBaseUpdateApiKeyAction;
import org.elasticsearch.xpack.security.authc.ApiKeyService;
import org.elasticsearch.xpack.security.authz.store.CompositeRolesStore;

public final class TransportUpdateApiKeyAction
extends TransportBaseUpdateApiKeyAction<UpdateApiKeyRequest, UpdateApiKeyResponse> {
    private final ApiKeyService apiKeyService;

    @Inject
    public TransportUpdateApiKeyAction(TransportService transportService, ActionFilters actionFilters, ApiKeyService apiKeyService, SecurityContext context, CompositeRolesStore rolesStore, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/xpack/security/api_key/update", transportService, actionFilters, UpdateApiKeyRequest::new, context, rolesStore, xContentRegistry);
        this.apiKeyService = apiKeyService;
    }

    @Override
    void doExecuteUpdate(Task task, UpdateApiKeyRequest request, Authentication authentication, Set<RoleDescriptor> roleDescriptors, ActionListener<UpdateApiKeyResponse> listener) {
        this.apiKeyService.updateApiKeys(authentication, BulkUpdateApiKeyRequest.wrap((UpdateApiKeyRequest)request), roleDescriptors, (ActionListener<BulkUpdateApiKeyResponse>)ActionListener.wrap(bulkResponse -> listener.onResponse((Object)this.toSingleResponse(request.getId(), (BulkUpdateApiKeyResponse)bulkResponse)), arg_0 -> listener.onFailure(arg_0)));
    }

    private UpdateApiKeyResponse toSingleResponse(String apiKeyId, BulkUpdateApiKeyResponse response) throws Exception {
        if (response.getTotalResultCount() != 1) {
            throw new IllegalStateException("single result required for single API key update but result count was [" + response.getTotalResultCount() + "]");
        }
        if (!response.getErrorDetails().isEmpty()) {
            Map.Entry errorEntry = response.getErrorDetails().entrySet().iterator().next();
            if (!((String)errorEntry.getKey()).equals(apiKeyId)) {
                this.throwIllegalStateExceptionOnIdMismatch(apiKeyId, (String)errorEntry.getKey());
            }
            throw (Exception)errorEntry.getValue();
        }
        if (!response.getUpdated().isEmpty()) {
            String updatedId = (String)response.getUpdated().get(0);
            if (!updatedId.equals(apiKeyId)) {
                this.throwIllegalStateExceptionOnIdMismatch(apiKeyId, updatedId);
            }
            return new UpdateApiKeyResponse(true);
        }
        String noopId = (String)response.getNoops().get(0);
        if (!noopId.equals(apiKeyId)) {
            this.throwIllegalStateExceptionOnIdMismatch(apiKeyId, noopId);
        }
        return new UpdateApiKeyResponse(false);
    }

    private void throwIllegalStateExceptionOnIdMismatch(String requestId, String responseId) {
        String message = "response ID [" + responseId + "] does not match request ID [" + requestId + "] for single API key update";
        assert (false) : message;
        throw new IllegalStateException(message);
    }
}

